<?php

namespace Suiterus\Adg\Controllers\LearningDevelopment;

use Illuminate\Database\Eloquent\ModelNotFoundException as ME;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Suiterus\Adg\Models\LearningDevelopment\Demerit;
use App\Models\User;
use Validator;
use Exception;
use DB;

class DemeritController extends Controller
{
    //CREATE
    public function create(Request $req)
    {
        $valid = Validator::make($req->all(), [
            'user_id'       => 'required|integer',
            'subject'       => 'required|integer',
            'effect_date'   => 'required|date',
            'message'       => 'required',
            'points'        => 'required',
        ]);
        if ($valid->fails()) {
            return response()->json(
                [
                    'errors' => $valid->errors(),
                ],
                400
            );
        }
        DB::beginTransaction();
        try {
            Demerit::create([
                'user_id'       => $req->user_id,
                'subject'       => $req->subject,
                'effect_date'   => $req->effect_date,
                'message'       => $req->message,
                'points'        => $req->points,
                'status'        => 3,
                'created_by'    => $req->user()->id,
                'updated_by'    => $req->user()->id,
                'created_at'    => now(),
                'updated_at'    => now(),
            ]);
            
            DB::commit();

            return response()->json([
                'text' => 'New demerit record have been created.',
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json(
                [
                    'errors' => ['Can`t create your entry as of now. Contact the developer to fix it. Error Code : AM-comp-0x05'],
                    'msg' => $e->getMessage(),
                ],
                500
            );
        }
    }

    //UPDATE
    public function edit(Request $req) {

        $valid = Validator::make($req->all(), [
            'id'            => 'required|exists:adg_db.demerits,id',
            'user_id'       => 'required|integer',
            'subject'       => 'required|integer',
            'effect_date'   => 'required|date',
            'message'       => 'required',
            'points'        => 'required',
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {

            $record = Demerit::findOrFail($req->id);

            $record->update([
                'user_id'       => $req->user_id,
                'subject'       => $req->subject,
                'effect_date'   => $req->effect_date,
                'message'       => $req->message,
                'points'        => $req->points,
                'updated_at'    => now(),
            ]); 

            $record->save();
            DB::commit();
            return response()->json([
                'text'  => $record->user->name . "'s record has been updated."
            ]);

        } catch(ME $e) {
            return response()->json([
                'errors'    => ['The selected record could not be found.'],
                'message'   => $e->getMessage()
            ], 500);
        } catch(Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in editing the record.'],
                'message'   => $e->getMessage()
            ], 500);
        }

    }

    // DELETE
    public function delete(Request $request) {

        $valid = Validator::make($request->all(), [
            'id'            => 'required|exists:adg_db.demerits,id',
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try  {

            $record = Demerit::findOrFail($request->id);
            $name = $record->user->name;
            $record->delete();

            DB::commit();

            return response()->json([
                'text'  => $name . "'s has been deleted."
            ]); 

        } catch(ME $e) {
            return response()->json([
                'errors'    => ['The selected record could not be found.'],
                'message'   => $e->getMessage()
            ], 500);
        } catch(Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in deleting the record.'],
                'message'   => $e->getMessage()
            ], 500);
        }

    }

    //FETCH ALL
    public function init_list(Request $req)
    {
        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');

        $d = Demerit::whereHas('user.employeeMetaInfo')->with(['user' => function($q){
            $q->select('id','name')->without(['storage','roles', 'permissions']);
        },'user.employeeMetaInfo' =>function($q){ 
            $q->select('id','user_id', 'employee_id')->without('employeeType','corporation','division','department','branch'); 
        }])->select('id','user_id','subject','effect_date','message','points','status')->paginate($paginate);
       
        return response()->json([
            'text' => 'fetch successful.',
            'data' => $d,
        ]);
    }

    //FILTER RECORDS
    public function filter(Request $req){
        $paginate = $req->paginate ? intval($req->paginate) : env('DEFAULT_PAGECOUNT');
        try{
            $users = Demerit::whereHas('user', function($query) use ($req) {
                $query->select('id', 'name')->where('name', 'LIKE', '%' . $req->employee_name . '%')
                    ->without(['storage', 'roles', 'permissions'])
                    ->whereHas('employeeMetaInfo')
                    ->with(['employeeMetaInfo' => function($query) {
                        $query->select('id','user_id', 'employee_id')->without('employeeType','corporation','division','department','branch'); 
                    }]);
            })
            ->with(['user'])
            ->when(count($req->filter_dates)>0, function($q) use ($req){
                $q->when(count($req->filter_dates)>1, function($q) use ($req){
                    $q->whereDate('effect_date', '>=', $req->filter_dates[0])
                    ->whereDate('effect_date', '<=', $req->filter_dates[1]);
                });
                $q->when(count($req->filter_dates)==1, function($q) use ($req){
                    $q->whereDate('effect_date', $req->filter_dates[0]);
                });
            })->when($req->subject!=null, function($q) use ($req){
                $q->where('subject', $req->subject);
            })->when($req->points!=null, function($q) use ($req){
                $q->where('points', $req->points);
            })->when($req->message!=null, function($q) use ($req){
                $q->where('message', "LIKE", '%'.$req->message.'%');
            })
            ->select('id','user_id','subject','effect_date','message','points','status');

            //Employee filter
            if(count($req->employees) > 0) {
                $users->whereIn('user_id', $req->employees);
            }

            return response()->json([
                'data' => $users->orderBy('created_at', 'asc')->paginate($paginate)
            ]);
        
        } 
        catch (ME $me) {
            return response()->json([
                'errors'    => ['The selected filters could not be found.'],
                'message'   => $me->getMessage()
            ], 500);
        } catch (Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in fetching the records.'],
                'message'   => $e->getMessage()
            ], 500);
        }
    }

    // APPROVE
    public function approve(Request $req) {

        $valid = Validator::make($req->all(), [
            'id'            => 'required|exists:adg_db.demerits,id',
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {
            $record = Demerit::where('status', 3)->findOrFail($req->id);

            $record->update([
                'status'       => 1,
                'updated_at'   => now(),
            ]); 

            $record->save();
            DB::commit();
            return response()->json([
                'text'  => $record->user->name . "'s record has been approved."
            ]);

        } catch(ME $e) {
            return response()->json([
                'errors'    => ['The selected record could not be found.'],
                'message'   => $e->getMessage()
            ], 500);
        } catch(Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in approving the record.'],
                'message'   => $e->getMessage()
            ], 500);
        }

    }

    // DECLINE
    public function decline(Request $req) {
        $valid = Validator::make($req->all(), [
            'id'            => 'required|exists:adg_db.demerits,id',
        ]);

        if($valid->fails()) {
            return response()->json([
                'errors'    => $valid->errors()
            ], 400);
        }

        DB::beginTransaction();
        try {
            $record = Demerit::where('status', 3)->findOrFail($req->id);

            $record->update([
                'status'       => 2,
                'updated_at'   => now(),
            ]); 

            $record->save();
            DB::commit();
            return response()->json([
                'text'  => $record->user->name . "'s record has been declined."
            ]);

        } catch(ME $e) {
            return response()->json([
                'errors'    => ['The selected record could not be found.'],
                'message'   => $e->getMessage()
            ], 500);
        } catch(Exception $e) {
            return response()->json([
                'errors'    => ['There was a problem in declining the record.'],
                'message'   => $e->getMessage()
            ], 500);
        }

    }
}
