<?php

namespace Suiterus\Adg\Controllers;

use App\Models\User;
use App\Enums\Log\AttendanceLogType;
use Illuminate\Http\Request;
use App\Enums\Log\CSVLogType;
use App\Traits\Logs\HasCustomLogs;
use Suiterus\Adg\Models\SM\Branch;
use Suiterus\Hrjp\Models\Position;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\Corporation;
use Suiterus\Adg\Imports\EmployeeImport;
use Suiterus\Adg\Models\SM\EmployeeType;
use Suiterus\Adg\Models\SM\ScheduleTitle;
use Suiterus\Adg\Imports\AttendanceImport;
use Suiterus\Adg\Models\Activity\Activity;
use Suiterus\Adg\Exports\BCE\EmployeesExport;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Dms\Models\Repositories\Section;
use Suiterus\Dms\Models\Repositories\SectionAccess;
use Suiterus\Adg\Exports\BCE\EmployeesExportFailure;
use Suiterus\Adg\Exports\Attendance\AttendanceExport;
use Suiterus\Adg\Exports\Attendance\AttendanceExportFailure;

class CSVController extends Controller
{

    use HasCustomLogs;

    public function validate_export(){
        $countEmployeeType = EmployeeType::first();
        $countPosition = Position::first();
        $countSchedule = ScheduleTitle::where('active_schedule', 1)->first();
        if ($countEmployeeType != '' && $countPosition != '' && $countSchedule != '') {
            return response()->json([
                'message'    => 'success',
            ]); 
        }else{
            return response()->json([
                'errors'    => ['Please configure branch, corporation, department, division, position, employee type and default schedule before downloading CSV.'],
            ], 400); 
        }
    }

    public function export_employee(Request $req){
        return (new EmployeesExport($req->rows))->download('corporation.xlsx');
    }

    public function export_attendance(Request $request) {

        $this->logCustomMessage(
            'download_template_attendance',
            null,
            Auth::user()->name . ' Download template attendance',
            null,
            AttendanceLogType::DOWNLOAD,
            new Activity()
        );

        return (new AttendanceExport($request->rows))->download('attendance.xlsx');
    }

    public function export_employee_failure(Request $req){
        $value = $req->all();
        return (new EmployeesExportFailure($value))->download('corporation.xlsx');
    }

    public function export_attendance_failure(Request $req){
        $value = $req->all();
        return (new AttendanceExportFailure($value))->download('attendance.xlsx');
    }

    public function import_employee(Request $req){
        $file = $req->file('batch_employee');
      
        $import = new EmployeeImport();
        $import->import($file);

        foreach ($import->failures() as $failure) {
            $failure->row(); // row that went wrong
            $failure->attribute(); // either heading key (if using heading row concern) or column index
            $failure->errors(); // Actual error messages from Laravel validator
            $failure->values(); // The values of the row that has failed.
        }

        //temporary
        $user = User::latest()->take($import->getRowCount())->get();
        $activeFolderId = Section::where("name", "Active Employee")->pluck('id')->first();
        $folder_employee = [];
        
        foreach ($user as $userFolder) {
            $existingFolder = Section::where('name', EmployeeMetaInfo::where('user_id', $userFolder['id'])->pluck('employee_id')->first() . ' - ' . $userFolder['name'])
            ->where('parent_id', $activeFolderId)->first();
        
            if (!$existingFolder) {
                $folder_employee[] = [
                    'name' => EmployeeMetaInfo::where('user_id', $userFolder['id'])->pluck('employee_id')->first() . ' - ' . $userFolder['name'],
                    'parent_id' => $activeFolderId,
                    'type' => 1,
                    "status" => 1,
                    "created_by" => 2,
                    "created_at" => now(),
                    "updated_at" => now()
                ];
        
                $this->logCustomMessage(
                    'create_bulk',
                    $userFolder,
                    Auth::user()->name . ' bulk create new employees',
                    $userFolder,
                    CSVLogType::BULK_EMPLOYEE,
                    new Activity()
                );
            }
        }
        
        Section::insert($folder_employee);
        
        $folderIds = Section::latest()->take($import->getRowCount())->get();
        $folder_access_employee = [];
        
        foreach ($folderIds as $folderId) {
            $existingAccess = SectionAccess::where('section_id', $folderId['id'])->where('user_id', 2)->exists();

            if (!$existingAccess) {
                $folder_access_employee[] = [
                    "section_id" => $folderId['id'],
                    'user_id' => 2,
                    'access_level' => 1,
                    "created_at" => now(),
                    "updated_at" => now()
                ];
            }
        }
        
        SectionAccess::insert($folder_access_employee);
        
        //end temporary
        return response()->json([
            'rowCountSuccess' => $import->getRowCount(),
            'errors' => $import->failures()
        ]);
    }

    public function import_attendance(Request $req){
        $file = $req->file('batch_attendance');
      
        $import = new AttendanceImport();
        $import->import($file);
        
        foreach ($import->failures() as $failure) {
            $failure->row(); // row that went wrong
            $failure->attribute(); // either heading key (if using heading row concern) or column index
            $failure->errors(); // Actual error messages from Laravel validator
            $failure->values(); // The values of the row that has failed.
        }
        
        $this->logCustomMessage(
            'upload_template_attendance',
            null,
            Auth::user()->name . ' Upload template attendance',
            null,
            AttendanceLogType::UPLOAD_TEMPLATE,
            new Activity()
        );

        return response()->json([
            'rowCountSuccess' => $import->getRowCount(),
            'errors' => $import->failures()
        ]);
    }

    
}
