<?php

namespace Suiterus\Adg\Controllers\Approvals\Services;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Suiterus\Adg\Models\Approvals\CTO\COCPoints;
use Suiterus\Adg\Models\Approvals\CTO\COCPointsDeduction;
use Suiterus\Adg\Models\Approvals\CTO\COCPointsEarning;
use Suiterus\Adg\Models\Approvals\CTO\CTOApplication;
use Suiterus\Adg\Models\Approvals\OvertimeAccomplishmentReport;
use Suiterus\Adg\Models\Approvals\UserOvertime;

class COCPointService {

    // Decrease Points
    public function deductPoints($record, $coc_points) {
        $user_id = $record->user_id;
    
        $coc_points_record = COCPoints::where('user_id', $user_id)->first();
        
        $decreased_points = $coc_points_record->points - $coc_points;

        $this->recordDeduction($record, $coc_points, $decreased_points);

        $coc_points_record->points = $decreased_points;
        $coc_points_record->save();
   
    }

    public function recordDeduction($record, $coc_points, $decreased_points) {
        $user = User::whereId($record->user_id)->first();
        $coc = COCPoints::where('user_id', $user->id)->first();

        COCPointsDeduction::create([
            'user_id'           => $user->id,
            'coc_points_id'     => $coc->id,
            'period'            => Carbon::now(),
            'points'           =>  $coc_points,
            'remarks'           => 'Points Deducted',
            'resulting_points' => $decreased_points,
            'created_by'        => Auth::id(),
        ]);
    }

    public function recordIncrease($employee, $coc_points, $mh_rendered) {
        $point = COCPoints::where('user_id', $employee)->first();

        COCPointsEarning::create([
            'user_id'          => $employee,
            'coc_points_id'     => $point->id,
            'period'            => Carbon::now(),
            'points'           =>  $mh_rendered,
            'remarks'           => 'Points Earned',
            'resulting_points' => $coc_points,
            'created_by'        => Auth::id() ?? null
        ]);
    }

    public function resetPointsAnnually() {
        $active = 1;
        $employees = User::where('status', $active)->whereHas('employeeMetaInfo')->whereHas('overtime.report', function($query) use($active){
            $query->where('status', $active);
        })->get();

        foreach($employees as $employee){
            $coc = COCPoints::whereHas('user')->each(function($coc){
                $coc->points = 0.00;
                $coc->save();
            });
        }    
    }

    public function initializeCOCPoints() {
        $active = 1;
        $employees = User::where('status', $active)->whereHas('employeeMetaInfo')->get();

        foreach($employees as $employee) {
            if($employee->coc_points()->count() == 0) {
                COCPoints::create([
                    'user_id'   =>  $employee->id,
                    'points'    =>  0,  
                    'created_by'    =>  Auth::id() ?? 2 // Developer account - default value if authentication is null 
                ]);
            }
        }
    }
}