<?php

namespace Suiterus\Adg\Controllers\Approvals\Employee;

use Exception;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth; 
use Illuminate\Support\Facades\Validator;
use Suiterus\Adg\Models\Approvals\UserUndertime;


class UserUndertimeController extends Controller
{
    public function create_user_undertime(Request $req) {
        $valid = Validator::make($req->all(),[

            'start_date' => 'required|date',
            'start_time' => 'required',
            'end_date' => 'required|date',
            'end_time' => 'required',
            'total_no_of_hours' => 'required'

        ]);

        if($valid->fails()){
            return response()->json([
                'errors'    =>  $valid->errors()
            ],400);
        }

        DB::beginTransaction();
        try {
            UserUndertime::create([
                'user_id' => Auth::id(),
                'start_date' => $req->start_date,
                'start_time' => $req->start_time,
                'end_date' => $req->end_date,
                'end_time' => $req->end_time,
                'total_no_of_hours' => $req->total_no_of_hours,
                'undertime_justification' => $req->undertime_justification,
                'status' => $req->status ? $req->status : 1,
                'created_by' => Auth::id(),
            ]);

            DB::commit();
            return response()->json([
                'text'  => 'Request Undertime has been created successfully.',
                'data'  => $req->all()
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                'errors'    =>  [ 'Can`t create your entry as of now. Contact the developer to fix it. Error Code : UT-comp-0x01' ],
                'msg'   =>  $e->getMessage()
            ],500);
        }
    }

    public function fetch_user_undertime(Request $req){
        $paginate = $req->page_count ? intval($req->page_count) : env('DEFAULT_PAGECOUNT');
        return UserUndertime::when($req->total_no_of_hours != '' && $req->total_no_of_hours != null, function($query) use($req){
            return $query->where('total_no_of_hours', $req->total_no_of_hours);

        })->when(isset($req->filter_dates) && count($req->filter_dates) > 0, function($query) use ($req) {
            $query->when(count($req->filter_dates) == 1, function($query) use($req){
                $query->whereDate('start_date', $req->filter_dates[0])
                ->orWhereDate('end_date', $req->filter_dates[0]);  
            })
            ->when(count($req->filter_dates) == 2, function($query) use ($req) {
                $query->where(function($query) use($req) {
                    $query->whereDate('start_date', '>=', $req->filter_dates[0])
                        ->whereDate('end_date', '<=', $req->filter_dates[1]);
                });
            });

        })->when($req->status != '' && $req->status != null, function($query) use($req){
            return $query->where('status', $req->status);

        })->whereHas('user', function($query){
            $query->when(Auth::id() != '' && Auth::id() != null, function($query){
                return $query->where('id', Auth::id());
            });
           
        })->orderBy('created_at', 'DESC')->paginate($paginate);
    }

    public function fetch_schedule(){
        return response()->json([
            'data' => User::where('id', Auth::id())->with(['employeeSchedules' => function($query) {
                $query->with(['schedule_template' => function($query) { 
                    $query->with(['schedule_template' => function($query){
                        $query->with(['schedulable' => function($query){
                            $query->groupBy('time_out');
                        }]);
                    }]); 
                }])->without(['user']);
            }])->without(['storage','roles', 'permissions', 'employeeMetaInfo','supervisor'])->get()
                            
        ]); 
    }
}
