<?php

namespace Suiterus\Adg\Abstracts;

use alhimik1986\PhpExcelTemplator\PhpExcelTemplator;
use Illuminate\Support\Facades\Storage;

abstract class FileReport
{

    /**
     * The function exports data to a CSV file using a predefined template and saves it in a specified
     * directory.
     *
     * @param array data An array of data that will be exported to the CSV file.
     * @param String fileName The fileName parameter is a string that represents the name of the CSV
     * file that will be generated.
     * @param reportType The `reportType` parameter is an optional parameter that specifies the type of
     * report template to use. It can be used to determine which template should be used for generating
     * the CSV file. If no report type is specified, you can pass `null` as the value for this
     * parameter.
     *
     * @return the value of the variable fileName.
     */
    public function exportToCSV(array $data, String $fileName, $path)
    {

        if (!Storage::disk('generated_reports')->exists(dirname($fileName))) {
            Storage::disk('generated_reports')->makeDirectory(dirname($fileName));
        }

        PhpExcelTemplator::saveToFile(public_path($path), Storage::disk('generated_reports')->path($fileName), $data);

        return $fileName;
    }
}
