"use strict";

var assert = require('chai').assert;
var Multimap = require('..');

var map = new Multimap([
  ['a', 'one'],
  ['b', 1],
  ['a', 'two'],
  ['b', 2]
]);

assert.equal(map.size, 4);
assert.equal(map.count, 2);

assert.equal(map.get('a').length, 2);
assert.equal(map.get('a')[0], 'one'); // ['one', 'two']
assert.equal(map.get('a')[1], 'two'); // ['one', 'two']

assert.equal(map.get('b').length, 2);
assert.equal(map.get('b')[0], 1); // [1, 2]
assert.equal(map.get('b')[1], 2); // [1, 2]


assert(map.has('a'), "map contains key 'a'");
assert(!map.has('foo'), "map does not contain key 'foo'");

assert(map.has('a', 'one'), "map contains entry 'a'=>'one'");
assert(!map.has('b', 3), "map does not contain entry 'b'=>3");

map.set('a', 'three');

assert.equal(map.size, 5);
assert.equal(map.count, 2);
assert.equal(map.get('a').length, 3); // ['one', 'two', 'three']

map.set('b', 3, 4);
assert.equal(map.size, 7);
assert.equal(map.count, 2);

assert(map.delete('a', 'three'), "delete 'a'=>'three'");
assert.equal(map.size, 6);
assert.equal(map.count, 2);
assert(!map.delete('x'), "empty 'x' for delete");
assert(!map.delete('a', 'four'), "no such entry 'a'=>'four'");
assert(map.delete('b'), "delete all 'b'");

assert.equal(map.size, 2);
assert.equal(map.count, 1);

map.set('b', 1, 2);
assert.equal(map.size, 4); // 4
assert.equal(map.count, 2);

var cnt = 0;
map.forEach(function(value, key) {
  // iterates { 'a', 'one' }, { 'a', 'two' }, { 'b', 1 }, { 'b', 2 }
  cnt++;
  assert(key == 'a' || key == 'b', "key must be either 'a' or 'b'");
});

assert.equal(cnt, 4);

cnt = 0;
map.forEachEntry(function(entry, key) {
  // iterates { 'a', ['one', 'two'] }, { 'b', [1, 2] }
  cnt++;
  assert(key == 'a' || key == 'b', "key must be either 'a' or 'b'");
  assert.equal(entry.length, 2);
});

assert.equal(cnt, 2);


var keys = map.keys(); // ['a', 'b']
assert.equal(keys.next().value, 'a');
assert.equal(keys.next().value, 'b');
assert(keys.next().done);

var values = map.values(); // ['one', 'two', 1, 2]
assert.equal(values.next().value, 'one');
assert.equal(values.next().value, 'two');
assert.equal(values.next().value, 1);
assert.equal(values.next().value, 2);
assert(values.next().done);


map.clear();

assert.equal(map.size, 0);
assert.equal(map.count, 0);
