<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Hrjp\Models\SupplementalDetails as SD_type;

class UpdateSupplementalDetailsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        
        $reqdetails = [
            [
                'title'             => 'BIR Form 1902, revised 2000:',
                'status'            => 1,
                'additional_info'   => 'For New Hired Employee without previous BIR Tax Identification Number or TIN.',
                'purpose'           => 5,
                'created_at'        => now(),
                'updated_at'        => now(),            
            ],
            [
                'title'             => 'BIR Form 2305, revised 2008:',
                'status'            => 1,
                'additional_info'   => 'For Emplyoee with previous / existing BIR Tax Identification Number or TIN.',
                'purpose'           => 5,
                'created_at'        => now(),
                'updated_at'        => now(),            
            ],
            
        ];

        foreach ($reqdetails as $details) {
            SD_type::where('title', $details['additional_info'])->update([
                'title' => $details['title'],
                'additional_info' => $details['additional_info']
            ]);
        }

    }
}
