<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class UnifiedIdSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users = User::whereHas('employeeMetaInfo', function ($query) {
            $query->whereRaw("SUBSTRING(employee_id, -2) != '01'");
        })->withOut(
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
        )->with('employeeMetaInfo.employeeType')->get();

        foreach ($users as $user) {
            $user->employeeMetaInfo->employee_id = substr($user->employeeMetaInfo->employee_id, 0, -2) . '01';
            $user->employeeMetaInfo->save();
        }

    }
}
