<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\SystemModule;
use Illuminate\Support\Facades\Artisan;

class TimekeepingPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $timeKeeping = SystemModule::where('name', 'Time Keeping')->first();
        if ($timeKeeping) {
            $timeKeeping->name = 'Timekeeping';
            $timeKeeping->save();
        } else {
            $timeKeeping = SystemModule::where('name', 'Timekeeping')->first();
        }

        if ($timeKeeping) {
            $permissions = [
                [
                    'name' => 'can view roster reschedule request',
                    'display_name' => 'View Roster Reschedule',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can review reschedule request',
                    'display_name' => 'Review Roster Reschedule',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can view roster schedule',
                    'display_name' => 'View Roster Schedule',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can view roster table',
                    'display_name' => 'View Roster Table',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can set roster status',
                    'display_name' => 'Set Roster Status',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can update roster',
                    'display_name' => 'Update Roster',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can create roster',
                    'display_name' => 'Create Roster',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can set roster details',
                    'display_name' => 'Set Roster Details',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
                [
                    'name' => 'can assign roster schedule shift',
                    'display_name' => 'Assign Roster Shift',
                    'guard_name' => 'api',
                    'system_module_id' => $timeKeeping->id
                ],
            ];

            foreach ($permissions as $permissionData) {
                $permissionData['system_module_id'] = $timeKeeping->id;
                Permission::updateOrCreate(
                    ['name' => $permissionData['name'], 'system_module_id' => $permissionData['system_module_id']],
                    $permissionData
                );
            }

            Artisan::call('cache:clear');
        }
    }
}
