<?php

namespace Database\Seeders;

use Faker\Factory;
use Illuminate\Database\Seeder;
use Suiterus\Hrjp\Models\ItemCode;
use Suiterus\Hrjp\Models\Position;

class TestPositionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        for ($i=0; $i < 1000; $i++) {
            $position = Position::create([
                'title' => Factory::create()->jobTitle(),
                'created_by' => 2
            ]);

            ItemCode::create([
                'item_code' => Factory::create()->bothify('??##'),
                'position_id' => $position->id,
                'status' => 1,
            ]);
        }
    }
}
