<?php

namespace Database\Seeders;

use Faker\Factory;
use App\Models\User;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SM\Remark;
use Suiterus\Adg\Models\Salary\UserSalary;
use Suiterus\Adg\Models\PDS\PDSPerPosition;
use Suiterus\Adg\Models\Salary\PublicSalary;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\Salary\PrivateSalary;
use Suiterus\Adg\Models\Salary\EmployeeAllowance;
use Suiterus\Adg\Models\Salary\EmployeeSpecialPay;
use Suiterus\Adg\Models\ServiceRecord\ServiceRecord;
use Suiterus\Adg\Models\EMI\EmployeeExtraFieldColumn;
use Suiterus\Hrjp\Models\Position_history;

class TestEmployeeSalarySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users = User::doesntHave('salary')->whereNotIn('id', [1, 2])->get();
            foreach($users as $user) {
                $totalAllowance = 0;
                $data = null;

                $data = (object) $data;

                $userSalary = UserSalary::create([
                    'user_id' => $user->id,
                    'account_number' => Factory::create()->randomNumber(),
                    'appointment_date' => now(),
                    'date_of_effectivity' => now(),
                    'status'    =>  0,
                    'official_business_pay' => property_exists($data, 'official_business_pay') ? $data->official_business_pay : null,
                    'e_cola' => property_exists($data, 'ecola') ? $data->ecola : null,
                    'special_pay' =>property_exists($data, 'special_pay') ? $data->special_pay : null,
                    'load_allowance' => property_exists($data, 'load_allowance') ? $data->load_allowance : null,
                    'transportation_allowance' => property_exists($data, 'transportation_allowance') ? $data->transportation_allowance : null,
                    'branch_allowance' => property_exists($data, 'branch_allowance') ? $data->branch_allowance : null,
                    'gate_allowance' => property_exists($data, 'gate_allowance') ? $data->gate_allowance : null,
                    'rice_allowance' => property_exists($data, 'rice_allowance') ? $data->rice_allowance : null,
                    'substinence_allowance' => property_exists($data, 'substinence_allowance') ? $data->substinence_allowance : null,
                    'laundry_allowance' => property_exists($data, 'laundry_allowance') ? $data->laundry_allowance : null,
                    'remarks' => "Testing salary",
                    'created_by' => 2
                ]);

                $allAllowances = $totalAllowance;

                if (true) {
                    $publicSalary = PublicSalary::create([
                        'user_salary_id' => $userSalary->id,
                        'salary_grade_id' => Factory::create()->numberBetween(1, 258),
                    ]);
                    $salary = $publicSalary->salaryGrade->value;
                    $salary = str_replace( ',', '', $salary);
                    $annualSalary = $salary * 12;

                }
                // else if($req->sector == 'private'){
                //     PrivateSalary::create([
                //         'user_salary_id' => $userSalary->id,
                //         'salary' => $req->basicSalary
                //     ]);
                //     $annualSalary = $req->basicSalary * 12;
                // }

                $getPosition = EmployeeMetaInfo::where('user_id', $user->id)->first();

                $position_history = Position_history::with(['user' => function($query){
                    $query->select('id', 'name')->without('permissions', 'roles', 'storage', 'employeeMetaInfo');
                }, 'user.user_employeeMetaInfo' => function($query){
                    $query->select('id', 'user_id')->without(['storage','roles','permissions','department','branch','division','position','employeeMetaInfo']);
                }])->create([
                    'user_id'               => $user->id,
                    'position_id'           => $getPosition->position_id,
                    'appointment_date'      => now(),
                    'date_of_effectivity'   => now(),
                    'employment_status'     =>  0, //* currently employed
                    'position_status'       => 1,
                    'created_by'            => 2
                ]);

                $employeeExtraFieldColumn = EmployeeExtraFieldColumn::whereHas('employeeExtraField', function($query) use($user){
                    $query->where('user_id', $user->id);
                })->get();

                foreach($employeeExtraFieldColumn as $pds){
                    PDSPerPosition::create([
                        'position_history_id'   =>    $position_history->id,
                        'eefc_id'               =>    $pds->id,
                        'field_name'           =>     $pds->field_name,
                        'field_value'           =>    $pds->field_value,
                        'created_by'            =>    2
                    ]);
                }

                $oldServiceRecord = ServiceRecord::where('user_id', $user->id)->whereNull('end_date');;

                    $endDate = date('Y-m-d', strtotime(now()));
                    $oldServiceRecord->update([
                        'end_date'  => $endDate
                    ]);

                $remark = Remark::whereId(1)->first();

                ServiceRecord::create([
                    'user_id'           =>  $user->id,
                    'start_date'        =>  $getPosition->date_hired,
                    'position_id'       =>  $getPosition->position_id,
                    'salary'            =>  $annualSalary,
                    'allowance'         =>  $allAllowances,
                    'employee_type_id'  =>  $getPosition->employee_type,
                    'division_id'       =>  $getPosition->division_id,
                    'remark_id'         =>  $remark->id,  //* Original or Re-employment
                    'created_by'        =>  2
                ]);
            }
    }
}
