<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Hrjp\Models\ItemCode;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;

class TestEmployeePositionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $metaInfos = EmployeeMetaInfo::get();
        $index = 1;

        foreach ($metaInfos as $metaInfo) {
            $itemCode = ItemCode::where('id', $index)->first();
            if ($itemCode) {
                $metaInfo->update([
                    'item_code_id' => $itemCode->id,
                    'position_id' => $itemCode->position_id
                ]);
            }
            $index++;
        }
    }
}
