<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use App\Models\AccessManagement\GroupManagement\System;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class TalentManagementPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        SystemModule::updateOrCreate([
            'name' => 'Talent Management',
        ], [
            'name' => 'Talent Management',
            'system_id' => System::where('name', 'hris')->first()->id,
        ]);

        $systemModuleId = SystemModule::where('name', 'Talent Management')->first()->id;

        $permissions = [
            [
                'name' => 'can paginate mentorship',
                'display_name' => 'Paginate mentorship',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can paginate mentorship invite',
                'display_name' => 'Paginate mentorship invite',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can list mentorship invite',
                'display_name' => 'List mentorship invite',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can paginate mentorship mentor',
                'display_name' => 'Paginate mentorship mentor',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can download mentorship attachment',
                'display_name' => 'Download mentorship attachment',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can create mentorship',
                'display_name' => 'Create mentorship',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can update mentorship invite',
                'display_name' => 'Update mentorship invite status',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can create mentorship session',
                'display_name' => 'Create mentorship session',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can update mentorship session',
                'display_name' => 'Update mentorship session',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can paginate mentorship session',
                'display_name' => 'Paginate mentorship session',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can view mentorship session',
                'display_name' => 'View mentorship session',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can create mentorship report',
                'display_name' => 'Create mentorship report',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can update mentorship report',
                'display_name' => 'Update mentorship report',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
            [
                'name' => 'can view mentorship report',
                'display_name' => 'View mentorship report',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],

            //succession management permission
            [
                'name' => 'can paginate critical position',
                'display_name' => 'Paginate critical position',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],

            [
                'name' => 'can create critical position',
                'display_name' => 'Create critical position',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],

            [
                'name' => 'can show critical position',
                'display_name' => 'Show critical position',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],

            [
                'name' => 'can paginate successor',
                'display_name' => 'Paginate successor',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],

            [
                'name' => 'can create successor',
                'display_name' => 'Create successor',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],

            [
                'name' => 'can promote successor',
                'display_name' => 'Promote successor',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],

            [
                'name' => 'can show successor',
                'display_name' => 'Show successor',
                'guard_name' => 'api',
                'system_module_id' => $systemModuleId,
            ],
        ];

        foreach ($permissions as $permission) {
            Permission::updateOrCreate([
                'name' => $permission['name'],
            ], $permission);
        }

        Artisan::call('cache:clear');
    }
}
