<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AccessManagement\GroupManagement\System;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class SystemModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $systemModule = [
            [
                'name' => 'Private Folder',
                'system_id' => System::where('name', 'dms')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Shared Drive',
                'system_id' => System::where('name', 'dms')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Manage Approvals',
                'system_id' => System::where('name', 'dms')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Archive',
                'system_id' => System::where('name', 'dms')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Configure',
                'system_id' => System::where('name', 'dms')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'HR Management',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Time Keeping',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Payroll',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Recruitment',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Reports',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Approvals',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Exit',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ],
            [
                'name' => 'Setup',
                'system_id' => System::where('name', 'hris')->first()->id,
                'created_at' => now()
            ]
        ];

        SystemModule::insert($systemModule);
    }
}
