<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class SystemModulePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            [
                'name' => 'create private drive folder',
                'display_name' => 'Create Private Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'approval document private drive',
                'display_name' => 'Approval',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'upload document private drive',
                'display_name' => 'Upload File',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'update document private drive',
                'display_name' => 'Update',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'create document private drive',
                'display_name' => 'Create File', 
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'delete document private drive',
                'display_name' => 'Delete',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'forward document private drive',
                'display_name' => 'Forward',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'create shared drive folder',
                'display_name' => 'Create Shared Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'approval document shared drive',
                'display_name' => 'Approval',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'upload document shared drive',
                'display_name' => 'Upload File',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'update document shared drive',
                'display_name' => 'Update',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'create document shared drive',
                'display_name' => 'Create File',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'delete document shared drive',
                'display_name' => 'Delete',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'forward document shared drive',
                'display_name' => 'Forward',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'employee profile',
                'display_name' => 'Employee Profile',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'hr management')->first()->id
            ],
            [
                'name' => 'position and salary',
                'display_name' => 'Position and Salary',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'hr management')->first()->id
            ],
            [
                'name' => 'loans',
                'display_name' => 'Loans',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'hr management')->first()->id
            ],
            [
                'name' => 'leave',
                'display_name' => 'Leave',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'hr management')->first()->id
            ],
            [
                'name' => 'learning management',
                'display_name' => 'Learning Management',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'hr management')->first()->id
            ],
            [
                'name' => 'download document private drive',
                'display_name' => 'Download',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'download document shared drive',
                'display_name' => 'Download',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
        ];


        Permission::insert($permissions);
    }
}
