<?php

namespace Database\Seeders;

use App\Enums\Status;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\Payroll\SpecialPayFrequency;

class SpecialPayFrequencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $frequencies = [
            [
                'title' => 'Monthly',
                'status' => Status::ACTIVE,
            ],
            [
                'title' => 'Semi-Monthly',
                'status' => Status::ACTIVE,
            ],
            [
                'title' => 'Quarterly',
                'status' => Status::ACTIVE,
            ],
            [
                'title' => 'Annually',
                'status' => Status::ACTIVE,
            ],
            [
                'title' => 'Semi-Annually',
                'status' => Status::ACTIVE,
            ],
            
        ];
        foreach($frequencies as $frequency){
            SpecialPayFrequency::updateOrCreate(['title' => $frequency['title']], $frequency);
        }
    }
}
