<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SM\ScheduleType;

class ScheduleTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $types = [ 
            'Fixed Schedule',
            'Flexible Schedule',
            'Sliding Schedule'
        ];

        foreach($types as $type) {
            ScheduleType::create([
                'title'         => $type,
                'description'   => $type . ' Type',
                'status'        => 1,
                'created_by'    => 1,
                'updated_by'    => 1
            ]);
        }
    }
}
