<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class RosterTemplatePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $timeKeeping = SystemModule::where('name', 'Timekeeping')->first();

        $permissions = [
            [
                'name' => 'can paginate roster template',
                'display_name' => 'Paginate Roster Template',
                'guard_name' => 'api',
                'system_module_id' => $timeKeeping->id
            ],
            [
                'name' => 'can delete roster template',
                'display_name' => 'Delete Roster Template',
                'guard_name' => 'api',
                'system_module_id' => $timeKeeping->id
            ],
            [
                'name' => 'can list roster template',
                'display_name' => 'List Roster Template',
                'guard_name' => 'api',
                'system_module_id' => $timeKeeping->id
            ],
            [
                'name' => 'can create roster template',
                'display_name' => 'Create Roster Template',
                'guard_name' => 'api',
                'system_module_id' => $timeKeeping->id
            ],
            [
                'name' => 'can create roster from template',
                'display_name' => 'Create Roster from Template',
                'guard_name' => 'api',
                'system_module_id' => $timeKeeping->id
            ]
        ];

        foreach ($permissions as $permission) {
            $permission['system_module_id'] = $timeKeeping->id;
            Permission::updateOrCreate(
                ['name' => $permission['name'], 'system_module_id' => $permission['system_module_id']],
                $permission
            );
        }

        Artisan::call('cache:clear');
    }
}
