<?php

namespace Database\Seeders;

use App\Enums\Status;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SM\Shift;

class RosterShiftSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $shifts = [
            [
                'code'         =>  'A',
                'name'         =>  '6a3p',
                'description'  =>  'N/A',
                'shift_in'     =>  '06:00:00',
                'shift_out'    =>  '15:00:00',
                'break_in'     =>  '10:00:00',
                'break_out'    =>  '11:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'B',
                'name'         =>  '7a4p',
                'description'  =>  'N/A',
                'shift_in'     =>  '07:00:00',
                'shift_out'    =>  '16:00:00',
                'break_in'     =>  '11:00:00',
                'break_out'    =>  '12:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'C',
                'name'         =>  '730a430p',
                'description'  =>  'N/A',
                'shift_in'     =>  '06:00:00',
                'shift_out'    =>  '15:00:00',
                'break_in'     =>  '10:00:00',
                'break_out'    =>  '11:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'D',
                'name'         =>  '8a5p',
                'description'  =>  'N/A',
                'shift_in'     =>  '08:00:00',
                'shift_out'    =>  '17:00:00',
                'break_in'     =>  '12:00:00',
                'break_out'    =>  '13:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'E',
                'name'         =>  '8a4p',
                'description'  =>  'N/A',
                'shift_in'     =>  '08:00:00',
                'shift_out'    =>  '16:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'F',
                'name'         =>  '830a530p',
                'description'  =>  'N/A',
                'shift_in'     =>  '08:30:00',
                'shift_out'    =>  '17:30:00',
                'break_in'     =>  '12:30:00',
                'break_out'    =>  '13:30:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'G',
                'name'         =>  '9a6p',
                'description'  =>  'N/A',
                'shift_in'     =>  '09:00:00',
                'shift_out'    =>  '18:00:00',
                'break_in'     =>  '13:00:00',
                'break_out'    =>  '14:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'H',
                'name'         =>  '9a10p',
                'description'  =>  'N/A',
                'shift_in'     =>  '09:00:00',
                'shift_out'    =>  '22:00:00',
                'break_in'     =>  '13:00:00',
                'break_out'    =>  '14:00:00',
                'work_hours'   =>  '13.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'I',
                'name'         =>  '10a7p',
                'description'  =>  'N/A',
                'shift_in'     =>  '10:00:00',
                'shift_out'    =>  '19:00:00',
                'break_in'     =>  '14:00:00',
                'break_out'    =>  '15:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'J',
                'name'         =>  '11a8p',
                'description'  =>  'N/A',
                'shift_in'     =>  '11:00:00',
                'shift_out'    =>  '20:00:00',
                'break_in'     =>  '15:00:00',
                'break_out'    =>  '16:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'K',
                'name'         =>  '12p8p',
                'description'  =>  'N/A',
                'shift_in'     =>  '12:00:00',
                'shift_out'    =>  '20:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'L',
                'name'         =>  '12p9p',
                'description'  =>  'N/A',
                'shift_in'     =>  '12:00:00',
                'shift_out'    =>  '21:00:00',
                'break_in'     =>  '16:00:00',
                'break_out'    =>  '17:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'M',
                'name'         =>  '1p10p',
                'description'  =>  'N/A',
                'shift_in'     =>  '13:00:00',
                'shift_out'    =>  '22:00:00',
                'break_in'     =>  '17:00:00',
                'break_out'    =>  '18:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'N',
                'name'         =>  '9p6a',
                'description'  =>  'N/A',
                'shift_in'     =>  '21:00:00',
                'shift_out'    =>  '06:00:00',
                'break_in'     =>  '01:00:00',
                'break_out'    =>  '02:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'O',
                'name'         =>  '430a130p',
                'description'  =>  'N/A',
                'shift_in'     =>  '04:30:00',
                'shift_out'    =>  '13:30:00',
                'break_in'     =>  '08:30:00',
                'break_out'    =>  '09:30:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'P',
                'name'         =>  '6a2p',
                'description'  =>  'N/A',
                'shift_in'     =>  '06:00:00',
                'shift_out'    =>  '14:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'Q',
                'name'         =>  '6a6p',
                'description'  =>  'N/A',
                'shift_in'     =>  '06:00:00',
                'shift_out'    =>  '18:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '12.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'R',
                'name'         =>  '6a7p',
                'description'  =>  'N/A',
                'shift_in'     =>  '06:00:00',
                'shift_out'    =>  '19:00:00',
                'break_in'     =>  '10:00:00',
                'break_out'    =>  '11:00:00',
                'work_hours'   =>  '13.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'S',
                'name'         =>  '7a3p',
                'description'  =>  'N/A',
                'shift_in'     =>  '07:00:00',
                'shift_out'    =>  '15:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'T',
                'name'         =>  '7a7p',
                'description'  =>  'N/A',
                'shift_in'     =>  '07:00:00',
                'shift_out'    =>  '19:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '12.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'U',
                'name'         =>  '8a8p',
                'description'  =>  'N/A',
                'shift_in'     =>  '08:00:00',
                'shift_out'    =>  '20:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '12.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'V',
                'name'         =>  '10a10p',
                'description'  =>  'N/A',
                'shift_in'     =>  '10:00:00',
                'shift_out'    =>  '22:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '12.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'W',
                'name'         =>  '2p10p',
                'description'  =>  'N/A',
                'shift_in'     =>  '14:00:00',
                'shift_out'    =>  '22:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'X',
                'name'         =>  'DAY-OFF',
                'description'  =>  'N/A',
                'shift_in'     =>  '',
                'shift_out'    =>  '',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'Y',
                'name'         =>  '2p11p',
                'description'  =>  'N/A',
                'shift_in'     =>  '14:00:00',
                'shift_out'    =>  '23:00:00',
                'break_in'     =>  '18:00:00',
                'break_out'    =>  '19:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  'Z',
                'name'         =>  '3p11p',
                'description'  =>  'N/A',
                'shift_in'     =>  '15:00:00',
                'shift_out'    =>  '23:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '1',
                'name'         =>  '6p6a',
                'description'  =>  'N/A',
                'shift_in'     =>  '18:00:00',
                'shift_out'    =>  '06:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '12.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '2',
                'name'         =>  '7p7a',
                'description'  =>  'N/A',
                'shift_in'     =>  '19:00:00',
                'shift_out'    =>  '07:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '12.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '3',
                'name'         =>  '10p6a',
                'description'  =>  'N/A',
                'shift_in'     =>  '22:00:00',
                'shift_out'    =>  '06:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '4',
                'name'         =>  '11p7a',
                'description'  =>  'N/A',
                'shift_in'     =>  '23:00:00',
                'shift_out'    =>  '07:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '5',
                'name'         =>  '10p7a',
                'description'  =>  'N/A',
                'shift_in'     =>  '22:00:00',
                'shift_out'    =>  '07:00:00',
                'break_in'     =>  '02:00:00',
                'break_out'    =>  '03:00:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '6',
                'name'         =>  '630a330p',
                'description'  =>  'N/A',
                'shift_in'     =>  '06:30:00',
                'shift_out'    =>  '15:30:00',
                'break_in'     =>  '10:30:00',
                'break_out'    =>  '11:30:00',
                'work_hours'   =>  '9.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '7',
                'name'         =>  '8a12p',
                'description'  =>  'N/A',
                'shift_in'     =>  '08:00:00',
                'shift_out'    =>  '12:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '4.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '8',
                'name'         =>  '1p7p',
                'description'  =>  'N/A',
                'shift_in'     =>  '13:00:00',
                'shift_out'    =>  '17:00:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '4.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '9',
                'name'         =>  '530a230p',
                'description'  =>  'N/A',
                'shift_in'     =>  '05:30:00',
                'shift_out'    =>  '14:30:00',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '8.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '10',
                'name'         =>  '7a8p',
                'description'  =>  'N/A',
                'shift_in'     =>  '07:00:00',
                'shift_out'    =>  '20:00:00',
                'break_in'     =>  '12:00:00',
                'break_out'    =>  '13:00:00',
                'work_hours'   =>  '13.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '11',
                'name'         =>  '8a9p',
                'description'  =>  'N/A',
                'shift_in'     =>  '08:00:00',
                'shift_out'    =>  '21:00:00',
                'break_in'     =>  '12:00:00',
                'break_out'    =>  '13:00:00',
                'work_hours'   =>  '13.00',
                'status'       =>  Status::ACTIVE
            ],
            [
                'code'         =>  '12',
                'name'         =>  '24-HOURS DUTY',
                'description'  =>  'N/A',
                'shift_in'     =>  '',
                'shift_out'    =>  '',
                'break_in'     =>  '',
                'break_out'    =>  '',
                'work_hours'   =>  '',
                'status'       =>  Status::INACTIVE
            ]
        ];

        foreach($shifts as $shift){
            Shift::updateOrCreate(['code' => $shift['code']], $shift);
        }
    }
}
