<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterLegend;

class RosterLegendSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $now = now();
        $legends = [
            [
                'key'           => 'charge-nurse',
                'name'          => 'Charge Nurse',
                'color'         => '#E9ff33',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
            [
                'key'           => 'e-cart',
                'name'          => 'E-Cart',
                'color'         => '#22d732',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
            [
                'key'           => '1st-call',
                'name'          => '1st Call',
                'color'         => '#f53fe7',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
            [
                'key'           => '2nd-call',
                'name'          => '2nd Call',
                'color'         => '#a2a2a2',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
            [
                'key'           => 'supplies',
                'name'          => 'Supplies',
                'color'         => '#ffffff',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
            [
                'key'           => 'senior-nurse-on-duty',
                'name'          => 'Senior Nurse On Duty',
                'color'         => '#9c1fe3',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
            [
                'key'           => 'leave',
                'name'          => 'Leave',
                'color'         => '#f9ce30',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
            [
                'key'           => 'seminar',
                'name'          => 'Seminar',
                'color'         => '#2e77f6',
                'created_at'    => $now,
                'updated_at'    => $now
            ],
        ];

        RosterLegend::insert($legends);
    }
}
