<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SPMS\PCRFormType;

class PCRFormTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $forms = [
            [
                'abbreviation' => 'IPCR',
                'name' => 'Individual Performance Commitment and Review',
            ],
            [
                'abbreviation' => 'UPCR',
                'name' => 'Unit Performance Commitment and Review',
            ],
            [
                'abbreviation' => 'SPCR',
                'name' => 'Section Performance Commitment and Review',
            ],
            [
                'abbreviation' => 'DiPCR',
                'name' => 'Division Performance Commitment and Review',
            ],
            [
                'abbreviation' => 'DePCR',
                'name' => 'Department Performance Commitment and Review',
            ],
            [
                'abbreviation' => 'DDPCR',
                'name' => 'Deputy Director Performance Commitment and Review',
            ],
            [
                'abbreviation' => 'OPCR',
                'name' => 'Office Performance Commitment and Review',
            ],
            [
                'abbreviation' => 'APCR',
                'name' => 'Agency Performance Commitment and Review',
            ]
        ];

        foreach ($forms as $form) {
            PCRFormType::updateOrCreate(
                [
                    'name' => $form['name'],
                ],
                [
                    'name' => $form['name'],
                    'abbreviation' => $form['abbreviation']
                ]
            );
        }
    }
}
