<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SPMS\PCRFormPermission;
use Suiterus\Adg\Models\SPMS\PCRFormType;

class PCRFormPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            [
                'name' => 'Rank and File',
                'permissions' => [
                    'create' => [
                        'IPCR'
                    ],
                    'view' => [
                        'IPCR',
                        'SPCR',
                        'UPCR'
                    ]
                ],
                'minimum_salary_grade' => 1,
                'maximum_salary_grade' => 14
            ],
            [
                'name' => 'Supervisor',
                'permissions' => [
                    'create' => [
                        'SPCR',
                        'UPCR'
                    ],
                    'view' => [
                        'SPCR',
                        'IPCR',
                        'UPCR',
                        'DiPCR'
                    ]
                ],
                'minimum_salary_grade' => 15,
                'maximum_salary_grade' => 21
            ],
            [
                'name' => 'Division Chief',
                'permissions' => [
                    'create' => [
                        'DiPCR',
                        'UPCR'
                    ],
                    'view' => [
                        'DiPCR',
                        'IPCR',
                        'SPCR',
                        'UPCR',
                        'DePCR'
                    ]
                ],
                'minimum_salary_grade' => 22,
                'maximum_salary_grade' => 24
            ],
            [
                'name' => 'Department Head',
                'permissions' => [
                    'create' => [
                        'DePCR',
                        'UPCR'
                    ],
                    'view' => [
                        'DePCR',
                        'UPCR',
                        'IPCR',
                        'SPCR',
                        'DiPCR',
                        'DDPCR'
                    ]
                ],
                'minimum_salary_grade' => 25,
                'maximum_salary_grade' => 26
            ],
            [
                'name' => 'Executive Director/Deputy Executive Director',
                'permissions' => [
                    'create' => [
                        'DDPCR',
                        'OPCR'
                    ],
                    'view' => [
                        'DDPCR',
                        'OPCR',
                        'IPCR',
                        'SPCR',
                        'UPCR',
                        'DiPCR',
                    ]
                ],
                'minimum_salary_grade' => 27,
                'maximum_salary_grade' => 33
            ]
        ];

        foreach ($permissions as $permission) {
            foreach ($permission['permissions']['create'] as $create) {
                $formType = PCRFormType::where('abbreviation', $create)->first();
                PCRFormPermission::updateOrCreate(
                    [
                        'name' => $permission['name'],
                        'pcr_form_type_id' => $formType->id,
                        'permission_type' => 1 // create
                    ],
                    [
                        'name' => $permission['name'],
                        'pcr_form_type_id' => $formType->id,
                        'permission_type' => 1, // create
                        'minimum_salary_grade' => $permission['minimum_salary_grade'],
                        'maximum_salary_grade' => $permission['maximum_salary_grade']
                    ]
                );
            }
            foreach ($permission['permissions']['view'] as $create) {
                $formType = PCRFormType::where('abbreviation', $create)->first();
                PCRFormPermission::updateOrCreate(
                    [
                        'name' => $permission['name'],
                        'pcr_form_type_id' => $formType->id,
                        'permission_type' => 2 // view
                    ],
                    [
                        'name' => $permission['name'],
                        'pcr_form_type_id' => $formType->id,
                        'permission_type' => 2, // view
                        'minimum_salary_grade' => $permission['minimum_salary_grade'],
                        'maximum_salary_grade' => $permission['maximum_salary_grade']
                    ]
                );
            }
        }
    }
}
