<?php

namespace Database\Seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Adg\Models\SM\OfficeHierarchy;
use Suiterus\Adg\Models\SPMS\Mfo;
use Suiterus\Adg\Models\SPMS\PCRFormType;
use Suiterus\Adg\Services\OrgStructure\OrgStructureService;

class OrganogramSeeder extends Seeder
{

    private $core = 1;
    private $strategic = 2;
    private $support = 3;

    private $ipcr = 1;
    private $upcr = 2;
    private $spcr = 3;
    private $dipcr = 4;
    private $depcr = 5;
    private $ddpcr = 6;
    private $opcr = 7;
    private $apcr = 8;

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $commonSetup = [
            $this->apcr => [
                'mfos' => [
                    $this->strategic => 50,
                    $this->core => 40,
                    $this->support => 10
                ],
            ],
            $this->ddpcr => [
                'mfos' => [
                    $this->strategic => 50,
                    $this->core => 40,
                    $this->support => 10
                ],
            ],
            $this->depcr => [
                'mfos' => [
                    $this->strategic => 50,
                    $this->core => 40,
                    $this->support => 10
                ],
            ],
            $this->dipcr => [
                'mfos' => [
                    $this->core => 70,
                    $this->support => 30
                ],
            ],
            $this->spcr => [
                'mfos' => [
                    $this->core => 70,
                    $this->support => 30
                ]
            ],
            $this->upcr => [
                'mfos' => [
                    $this->core => 70,
                    $this->support => 30
                ],
            ],
            $this->ipcr => [
                'mfos' => [
                    $this->core => 70,
                    $this->support => 30
                ],
            ]
        ];

        $executiveDirectorSetup = $commonSetup;
        $executiveDirectorSetup[$this->upcr] = [
            'mfos' => [
                $this->strategic => 50,
                $this->core => 40,
                $this->support => 10
            ],
        ];

        $medicalServicesResearchSetup = $commonSetup;
        $medicalServicesResearchSetup[$this->dipcr] = [
            'mfos' => [
                $this->strategic => 50,
                $this->core => 40,
                $this->support => 10
            ],
        ];

        $offices = [
            [
                'name' => 'BOARD OF TRUSTEES / EXECUTIVE COMMITTEE',
                'pcrs' => $commonSetup
            ],
            [
                'name' => 'EDUCATION, TRAINING, AND RESEARCH SERVICES', //special
                'pcrs' => $medicalServicesResearchSetup
            ],
            [
                'name' => 'HOSPITAL SUPPORT SERVICES',
                'pcrs' => $commonSetup
            ],
            [
                'name' => 'MEDICAL SERVICES', //special
                'pcrs' => $commonSetup
            ],
            [
                'name' => 'NURSING SERVICES',
                'pcrs' => $commonSetup
            ],
            [
                'name' => 'OFFICE OF EXECUTIVE DIRECTOR',
                'pcrs' => $executiveDirectorSetup
            ]
        ];
        foreach ($offices as $parentOffice) {
            $this->seedPcrs($parentOffice, new Office());
        }
    }

    private function seedPcrs($parentOrg, Model $model, $organization = null)
    {
        $organization = $organization ?? $model::where('name', $parentOrg['name'])->first();
        $organization->pcrs()->delete();
        $this->command->info("Seeding " . $organization->name);
        foreach ($parentOrg['pcrs'] as $key => $value) {
            $pcr = $organization->pcrs()->updateOrCreate(
                [
                    'pcr_form_type_id' => $key,
                ],
                [
                    'pcr_form_type_id' => $key,
                    'created_by' => 2
                ]
            );
            foreach ($value['mfos'] as $key => $value) {
                $pcr->mfos()->updateOrCreate(
                    [
                        'mfo_id' => $key,
                    ],
                    [
                        'mfo_id' => $key,
                        'percentage' => $value,
                    ]
                );
            }
        }

        if ($organization instanceof Office) {
            if ($organization->childOffices) {
                foreach ($organization->childOffices as $office) {
                    $this->seedPcrs($parentOrg, new Office(), $office->childOffice);
                }
            }
            $this->seedChild($parentOrg, $organization->department, Department::class, [$this->apcr, $this->ddpcr]);
            $this->seedChild($parentOrg, $organization->divisions, Division::class, [$this->apcr, $this->ddpcr, $this->depcr]);
            $this->seedChild($parentOrg, $organization->units, Unit::class, [$this->apcr, $this->ddpcr, $this->depcr, $this->dipcr]);
        } elseif ($organization instanceof Department) {
            $this->seedChild($parentOrg, $organization->divisions, Division::class, [$this->apcr, $this->ddpcr, $this->depcr]);
            $this->seedChild($parentOrg, $organization->units, Unit::class, [$this->apcr, $this->ddpcr, $this->depcr, $this->dipcr]);
        } elseif ($organization instanceof Division) {
            $this->seedChild($parentOrg, $organization->sections, Section::class, [$this->apcr, $this->ddpcr, $this->depcr, $this->dipcr]);
            $this->seedChild($parentOrg, $organization->units, Unit::class, [$this->apcr, $this->ddpcr, $this->depcr, $this->dipcr]);
        } elseif ($organization instanceof Section) {
            $this->seedChild($parentOrg, $organization->units, Unit::class, [$this->apcr, $this->ddpcr, $this->depcr, $this->dipcr]);
        }
    }

    private function seedChild($parentOrg, $organizations, $model, $unsetPcrs = [])
    {
        if ($organizations) {
            $parentOrg = $this->unsetPcrs($parentOrg, $unsetPcrs);
            foreach ($organizations as $organization) {
                $this->seedPcrs($parentOrg, new $model, $organization);
            }
        }
    }

    private function unsetPcrs($parentOrg, $pcrs = [])
    {
        foreach ($pcrs as $pcr) {
            unset($parentOrg['pcrs'][$pcr]);
        }
        return $parentOrg;
    }
}
