<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SM\Office;

class OfficeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $offices = [
            [
                'name' => 'Office of Board of Trustees',
                'description' => 'Office of Board of Trustees',
                'status' => 1, // 1 = active, 2 = inactive
                'created_by' => 2, 
            ],
            [
                'name' => 'Office of the Executive Director',
                'description' => 'Office of the Executive Director',
                'status' => 1, // 1 = active, 2 = inactive
                'created_by' => 2,
            ],
            [
                'name' => 'Office of the Deputy Executive Director for Medical Services',
                'description' => 'Office of the Deputy Executive Director for Medical Services',
                'status' => 1, // 1 = active, 2 = inactive
                'created_by' => 2,
            ],
            [
                'name' => 'Office of the Deputy Executive Director for Nursing Services',
                'description' => 'Office of the Deputy Executive Director for Nursing Services',
                'status' => 1, // 1 = active, 2 = inactive
                'created_by' => 2,
            ],
            [
                'name' => 'Office of the Deputy Executive Director for Education Trainings & Research Services',
                'description' => 'Office of the Deputy Executive Director for Education Trainings & Research Services',
                'status' => 1, // 1 = active, 2 = inactive
                'created_by' => 2,
            ],
            [
                'name' => 'Office of the Deputy Executive Director for Hospital Support Services',
                'description' => 'Office of the Deputy Executive Director for Hospital Support Services',
                'status' => 1, // 1 = active, 2 = inactive
                'created_by' => 2,
            ],
        ];
        foreach($offices as $office){
            Office::updateOrCreate(['name' => $office['name']], $office);
        }
    }
}
