<?php

namespace Database\Seeders;

use App\Models\Notifications\NotificationMessages;
use Illuminate\Database\Seeder;

class NotificationMessagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $notificationmessages = [
            [
                'header' => 'Approved',
                'sender_message' => 'You approved a document',
                'default_sender_message' => 'You approved a document',
                'receiver_message' => '{name} has approved your document',
                'default_receiver_message' => '{name} has approved your document'

            ],
            [
                'header' => 'Approval',
                'sender_message' => 'You submit a file for approval to {name}',
                'default_sender_message' => 'You approved a document',
                'receiver_message' => '{name} is waiting for your approval',
                'default_receiver_message' => '{name} has approved your document'

            ],
            [
                'header' => 'Checked',
                'sender_message' => 'You checked a document',
                'default_sender_message' => 'You checked a document',
                'receiver_message' => '{name} has checked your document',
                'default_receiver_message' => '{name} has checked your document'
            ],
            [
                'header' => 'Completed',
                'sender_message' => 'You completed a document',
                'default_sender_message' => 'You completed a document',
                'receiver_message' => '{name} has completed a document',
                'default_receiver_message' => '{name} has completed a document'
            ],
            [
                'header' => 'Reviewed',
                'sender_message' => 'You reviewed a document',
                'default_sender_message' => 'You reviewed a document',
                'receiver_message' => '{name} has reviewed your document',
                'default_receiver_message' => '{name} has reviewed your document'
            ],
            [
                'header' => 'Needs Revision',
                'sender_message' => 'You mark this document for revision',
                'default_sender_message' => 'You mark this document for revision',
                'receiver_message' => 'Your document needs revision',
                'default_receiver_message' => 'Your document needs revision'
            ],
            [
                'header' => 'Declined',
                'sender_message' => 'You declined a document',
                'default_sender_message' => 'You declined a document',
                'receiver_message' => '{name} has declined your document',
                'default_receiver_message' => '{name} has declined your document'
            ],
            [
                'header' => 'Returned a Document',
                'sender_message' => 'You have declined the {file} document, it will now return to previous level',
                'default_sender_message' => 'The {file} document has been declined by {name}. Please check remarks for details',
                'receiver_message' => 'You have declined the {file} document, it will now return to previous level',
                'default_receiver_message' => 'The {file} document has been declined by {name}. Please check remarks for details'
            ],
            [
                'header' => 'Forward',
                'sender_message' => 'You forwarded a file to {name}',
                'default_sender_message' => 'You forwarded a document',
                'receiver_message' => '{name} has forwarded you a document',
                'default_receiver_message' => '{name} has viewed your document'
            ],
            [
                'header' => 'Viewed',
                'sender_message' => 'You notified {name}',
                'default_sender_message' => 'You viewed a document',
                'receiver_message' => '{name} has viewed your forwarded document',
                'default_receiver_message' => '{name} has viewed your document'
            ],
            [
                'header' => 'Assign Signatory',
                'sender_message' => 'You assigned {name} to sign the document {file}',
                'default_sender_message' => '{name} is waiting for your signature in the document {file}.',
                'receiver_message' => '{name} is waiting for your signature in the document {file}.',
                'default_receiver_message' => '{name} is waiting for your signature in the document {file}.'
            ],
            [
                'header' => 'Signed a Document',
                'sender_message' => 'You signed the document {file}',
                'default_sender_message' => '{name} signed the document {file}',
                'receiver_message' => '{name} signed the document {file}',
                'default_receiver_message' => '{name} signed the document {file}'
            ],
            [
                'header' => 'Document Signed Completed',
                'sender_message' => 'The document {file} has been signed',
                'default_sender_message' => 'The document {file} has completed a sign',
                'receiver_message' => 'The document {file} has completed a sign',
                'default_receiver_message' => 'The document {file} has completed a sign'
            ],
        ];

        $overtimeNotifications = [
            [
                'header' => 'Approved Overtime Application',
                'sender_message' => 'You approved an overtime application of {name}',
                'default_sender_message' => 'You approved an overtime application of {name}',
                'receiver_message' => '{name} has approved your overtime application',
                'default_receiver_message' => '{name} has approved your overtime application'
            ],
            [
                'header' => 'Disapproved Overtime Application',
                'sender_message' => 'You disapproved an overtime application of {name}',
                'default_sender_message' => 'You disapproved an overtime application of {name}',
                'receiver_message' => '{name} has disapproved your overtime application',
                'default_receiver_message' => '{name} has disapproved your overtime application'
            ],
            [
                'header' => 'Approved Overtime Accomplishment',
                'sender_message' => 'You approved an overtime accomplishment of {name}',
                'default_sender_message' => 'You approved an overtime accomplishment of {name}',
                'receiver_message' => '{name} has approved your overtime accomplishment',
                'default_receiver_message' => '{name} has approved your overtime accomplishment'
            ],
            [
                'header' => 'Disapproved Overtime Accomplishment',
                'sender_message' => 'You disapproved an overtime accomplishment of {name}',
                'default_sender_message' => 'You disapproved an overtime accomplishment of {name}',
                'receiver_message' => '{name} has disapproved your overtime accomplishment',
                'default_receiver_message' => '{name} has disapproved your overtime accomplishment'
            ],
            [
                'header' => 'Approved CTO',
                'sender_message' => 'You approved a compensatory time-off for {name}',
                'default_sender_message' => 'You approved a compensatory time-off for {name}',
                'receiver_message' => '{name} has approved your compensatory time-off',
                'default_receiver_message' => '{name} has approved your compensatory time-off'
            ],
            [
                'header' => 'Disapproved CTO',
                'sender_message' => 'You disapproved a compensatory time-off for {name}',
                'default_sender_message' => 'You disapproved a compensatory time-off for {name}',
                'receiver_message' => '{name} has disapproved your compensatory time-off',
                'default_receiver_message' => '{name} has disapproved your compensatory time-off'
            ],
        ];

        $leaveNotifications = [
            [
                'header' => 'Approved leave',
                'sender_message' => 'You approved a leave for {name}',
                'default_sender_message' => 'You approved a leave for {name}',
                'receiver_message' => '{name} has approved your leave',
                'default_receiver_message' => '{name} has approved your leave'
            ],
            [
                'header' => 'Disapproved leave',
                'sender_message' => 'You disapproved a leave for {name}',
                'default_sender_message' => 'You disapproved a leave for {name}',
                'receiver_message' => '{name} has disapproved your leave',
                'default_receiver_message' => '{name} has disapproved your leave'
            ],
            [
                'header' => 'Canceled leave',
                'sender_message' => 'You canceled a leave for {name}',
                'default_sender_message' => 'You canceled a leave for {name}',
                'receiver_message' => '{name} has canceled your leave',
                'default_receiver_message' => '{name} has canceled your leave'
            ],
            [
                'header' => 'Request leave',
                'sender_message' => 'You requested a leave',
                'default_sender_message' => 'You requested a leave',
                'receiver_message' => '{name} has requested approval for leave',
                'default_receiver_message' => '{name} has requested approval for leave'
            ],

            [
                'header' => 'Request leave cancellation',
                'sender_message' => 'You requested a cancellation of leave',
                'default_sender_message' => 'You requested a cancellation of leave',
                'receiver_message' => '{name} has requested approval for cancellation of leave',
                'default_receiver_message' => '{name} has requested approval for cancellation of leave'
            ],
            [
                'header' => 'Insufficient Special Privilege Leave Balance',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'Your Special Privilege Leave Balance is insufficient, it will be deducted from your Vacation Leave Balance',
                'default_receiver_message' => 'Your Special Privilege Leave Balance is insufficient, it will be deducted from your Vacation Leave Balance'
            ],
            [
                'header' => 'Vacation Leave Deduction from Mandatory/Forced Leave',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'Your vacation leave balance has been adjusted due to the remaining forced leave. Please review your updated leave status',
                'default_receiver_message' => 'Your vacation leave balance has been adjusted due to the remaining forced leave. Please review your updated leave status'
            ]
        ];

        $loanNotifications = [
            [
                'header' => 'Create Loan',
                'sender_message' => 'You created a loan for {name}',
                'default_sender_message' => 'You created a loan for {name}',
                'receiver_message' => '{name} has created and approved your loan',
                'default_receiver_message' => '{name} has created and approved your loan'
            ],
            [
                'header' => 'Update Loan',
                'sender_message' => 'You updated a loan for {name}',
                'default_sender_message' => 'You updated a loan for {name}',
                'receiver_message' => '{name} has updated your loan',
                'default_receiver_message' => '{name} has updated your loan'
            ],
        ];

        $underTimeNotifications = [
            [
                'header' => 'Approve Undertime',
                'sender_message' => 'You have approved undertime for {name}',
                'default_sender_message' => 'You have approved undertime for {name}',
                'receiver_message' => '{name} has approved your undertime application',
                'default_receiver_message' => '{name} has approved your undertime application'
            ],
            [
                'header' => 'Decline Undertime',
                'sender_message' => 'You have declined undertime for {name}',
                'default_sender_message' => 'You have declined undertime for {name}',
                'receiver_message' => '{name} has declined your undertime application',
                'default_receiver_message' => '{name} has declined your undertime application'
            ],
        ];

        $rosterNotifications = [
            [
                'header' => 'Reschedule Approved',
                'sender_message' => 'You have approved the reschedule request from {name}',
                'default_sender_message' => 'You have approved the reschedule request from {name}',
                'receiver_message' => '{name} has approved your reschedule request',
                'default_receiver_message' => '{name} has approved your reschedule request',
            ],
            [
                'header' => 'Reschedule Declined',
                'sender_message' => 'You have declined the reschedule request from {name}',
                'default_sender_message' => 'You have declined the reschedule request from {name}',
                'receiver_message' => '{name} has declined your reschedule request',
                'default_receiver_message' => '{name} has declined your reschedule request',
            ],
        ];

        $employeeCasesNotifications = [
            [
                'header' => 'Create Case',
                'sender_message' => 'You have created a complaint case for {name}',
                'default_sender_message' => 'You have created a complaint case for {name}',
                'receiver_message' => '{name} has created a complaint case for you',
                'default_receiver_message' => '{name} has created a complaint case for you',
            ],
            [
                'header' => 'Update Case',
                'sender_message' => 'You have updated a complaint case for {name}',
                'default_sender_message' => 'You have updated a complaint case for {name}',
                'receiver_message' => '{name} has updated your complaint case',
                'default_receiver_message' => '{name} has updated your complaint case',
            ],
        ];

        $pdsNotifications = [
            [
                'header' => 'Approve PDS',
                'sender_message' => 'You have approved the PDS for {name}',
                'default_sender_message' => 'You have approved the PDS for {name}',
                'receiver_message' => '{name} has approved your PDS',
                'default_receiver_message' => '{name} has approved your PDS',
            ],
            [
                'header' => 'Decline PDS',
                'sender_message' => 'You have declined the PDS for {name}',
                'default_sender_message' => 'You have declined the PDS for {name}',
                'receiver_message' => '{name} has declined your PDS',
                'default_receiver_message' => '{name} has declined your PDS',
            ],

            [
                'header' => 'All PDS Approve',
                'sender_message' => 'All PDS submissions for {name} have been approved',
                'default_sender_message' => 'All PDS submissions for {name} have been approved',
                'receiver_message' => 'All your PDS submissions have been approved',
                'default_receiver_message' => 'All your PDS submissions have been approved',
            ],
            [
                'header' => 'All PDS Decline',
                'sender_message' => 'All PDS submissions for {name} have been declined',
                'default_sender_message' => 'All PDS submissions for {name} have been declined',
                'receiver_message' => 'All your PDS submissions have been declined',
                'default_receiver_message' => 'All your PDS submissions have been declined',
            ],
            [
                'header' => 'On Hold PDS',
                'sender_message' => 'PDS submissions for {name} have been put on hold',
                'default_sender_message' => 'PDS submissions for {name} have been put on hold',
                'receiver_message' => 'PDS submissions have been put on hold by {name}',
                'default_receiver_message' => 'PDS submissions have been put on hold by {name}',
            ],
        ];

        $clearanceNotifications = [
            [
                'header' => 'Create Clearance',
                'sender_message' => 'You have submitted a clearance for {name}',
                'default_sender_message' => 'You have submitted a clearance for {name}',
                'receiver_message' => '{name} has created your clearance',
                'default_receiver_message' => '{name} has created your clearance',
            ],
            [
                'header' => 'Approve Clearance',
                'sender_message' => 'You approve a clearance for {name}',
                'default_sender_message' => 'You approve a clearance for {name}',
                'receiver_message' => '{name} has approved your clearance',
                'default_receiver_message' => '{name} has approved your clearance',
            ],
            [
                'header' => 'Disapprove Clearance',
                'sender_message' => 'You disapprove a clearance for {name}',
                'default_sender_message' => 'You disapprove a clearance for {name}',
                'receiver_message' => '{name} has disapproved your clearance',
                'default_receiver_message' => '{name} has disapproved your clearance',
            ],
        ];

        $promotionNotifications = [
            //employee
            [
                'header' => 'Create Application',
                'sender_message' => 'You applied for a position title {custom_message}',
                'default_sender_message' => 'You applied for a position title {custom_message}',
                'receiver_message' => '{name} has applied for a promotion for position title {custom_message}',
                'default_receiver_message' => '{name} has applied for a promotion for position title {custom_message}',
            ],
            [
                'header' => 'Request Exam Reschedule',
                'sender_message' => 'You have requested a promotion exam reschedule',
                'default_sender_message' => 'You have requested a promotion exam reschedule',
                'receiver_message' => '{name} has requested a promotion exam reschedule',
                'default_receiver_message' => '{name} has requested a promotion exam reschedule',
            ],
            [
                'header' => 'Request Interview Reschedule',
                'sender_message' => 'You have requested a promotion interview reschedule',
                'default_sender_message' => 'You have requested a promotion interview reschedule',
                'receiver_message' => '{name} has requested a promotion interview reschedule',
                'default_receiver_message' => '{name} has requested a promotion interview reschedule',
            ],
            [
                'header' => 'Acknowledge Exam',
                'sender_message' => 'You have acknowledge the promotion exam schedule',
                'default_sender_message' => 'You have acknowledge the promotion exam schedule',
                'receiver_message' => '{name} has acknowledge the promotion exam schedule',
                'default_receiver_message' =>'{name} has acknowledge the promotion exam schedule',
            ],

            [
                'header' => 'Acknowledge Interview',
                'sender_message' => 'You have acknowledge the promotion interview schedule',
                'default_sender_message' => 'You have acknowledge the promotion interview schedule',
                'receiver_message' => '{name} has acknowledge the promotion interview schedule',
                'default_receiver_message' =>'{name} has acknowledge the promotion interview schedule',
            ],

            [
                'header' => 'Upload Requirement files',
                'sender_message' => 'You have uploaded your {custom_message} requirement file(s)',
                'default_sender_message' => 'You have uploaded your {custom_message} requirement file(s)',
                'receiver_message' => '{name} has uploaded their {custom_message} requirement file(s)',
                'default_receiver_message' =>'{name} has uploaded their {custom_message} requirement file(s)',
            ],
            //Admin
            [
                'header' => 'Create Requirements',
                'sender_message' => 'You have submitted a promotion requirements for {name}',
                'default_sender_message' => 'You have submitted a promotion requirements for {name}',
                'receiver_message' => '{name} has submitted a promotion requirements for you',
                'default_receiver_message' => '{name} has submitted a promotion requirements for you',
            ],
            [
                'header' => 'Approve Requirements',
                'sender_message' => 'You have approved requirements for {name}',
                'default_sender_message' => 'You have approved requirements for {name}',
                'receiver_message' => '{name} has approved your requirements',
                'default_receiver_message' => '{name} has approved your requirements',
            ],
            [
                'header' => 'Review Requirements',
                'sender_message' => 'You have {custom_message} the requirements for {name}',
                'default_sender_message' => 'You have {custom_message} the requirements for {name}',
                'receiver_message' => '{name} has {custom_message} your requirements',
                'default_receiver_message' => '{name} has {custom_message} your requirements',
            ],
            [
                'header' => 'Set Schedule Exam',
                'sender_message' => 'You have set a schedule for the promotion exam of {name}',
                'default_sender_message' => 'You have set a schedule for the promotion exam of {name}',
                'receiver_message' => '{name} has set a schedule for your promotion exam',
                'default_receiver_message' => '{name} has set a schedule for your promotion exam',
            ],
            [
                'header' => 'Set Schedule Interview',
                'sender_message' => 'You have set a schedule for the promotion interview of {name}',
                'default_sender_message' => 'You have set a schedule for the promotion interview of {name}',
                'receiver_message' => '{name} has set a schedule for your promotion interview',
                'default_receiver_message' => '{name} has set a schedule for your promotion interview',
            ],
            [
                'header' => 'Pass Exam',
                'sender_message' => 'You have passed {name} for the promotion exam',
                'default_sender_message' => 'You have passed {name} for the promotion exam',
                'receiver_message' => 'You have passed the promotion exam',
                'default_receiver_message' => 'You have passed the promotion exam',
            ],
            [
                'header' => 'Fail Exam',
                'sender_message' => 'You have failed {name} for the promotion exam',
                'default_sender_message' => 'You have failed {name} for the promotion exam',
                'receiver_message' => 'You have failed the promotion exam',
                'default_receiver_message' => 'You have failed the promotion exam',
            ],
            [
                'header' => 'Pass Interview',
                'sender_message' => 'You have passed {name} for the promotion Interview',
                'default_sender_message' => 'You have passed {name} for the promotion Interview',
                'receiver_message' => 'You have passed the promotion Interview',
                'default_receiver_message' => 'You have passed the promotion Interview',
            ],
            [
                'header' => 'Fail Interview',
                'sender_message' => 'You have failed {name} for the promotion Interview',
                'default_sender_message' => 'You have failed {name} for the promotion Interview',
                'receiver_message' => 'You have failed the promotion Interview',
                'default_receiver_message' => 'You have failed the promotion Interview',
            ],
            [
                'header' => 'Approve Reschedule Exam',
                'sender_message' => 'You have approved the reschedule request of {name} for the promotion exam',
                'default_sender_message' => 'You have approved the reschedule request of {name} for the promotion exam',
                'receiver_message' => '{name} has approved your request to reschedule the promotion exam',
                'default_receiver_message' => '{name} has approved your request to reschedule the promotion exam',
            ],
            [
                'header' => 'Disapprove Reschedule Exam',
                'sender_message' => 'You have disapproved the reschedule request of {name} for the promotion exam',
                'default_sender_message' => 'You have disapproved the reschedule request of {name} for the promotion exam',
                'receiver_message' => '{name} has disapproved your request to reschedule the promotion exam',
                'default_receiver_message' => '{name} has disapproved your request to reschedule the promotion exam',
            ],
            [
                'header' => 'Approve Reschedule Interview',
                'sender_message' => 'You have approved the reschedule request of {name} for the promotion interview',
                'default_sender_message' => 'You have approved the reschedule request of {name} for the promotion interview',
                'receiver_message' => '{name} has approved your request to reschedule the promotion interview',
                'default_receiver_message' => '{name} has approved your request to reschedule the promotion interview',
            ],
            [
                'header' => 'Disapprove Reschedule Interview',
                'sender_message' => 'You have disapproved the reschedule request of {name} for the promotion interview',
                'default_sender_message' => 'You have disapproved the reschedule request of {name} for the promotion interview',
                'receiver_message' => '{name} has disapproved your request to reschedule the promotion interview',
                'default_receiver_message' => '{name} has disapproved your request to reschedule the promotion interview',
            ],
            [
                'header' => 'Upload Form',
                'sender_message' => 'You have uploaded a document form(s)',
                'default_sender_message' => 'You have uploaded a document form(s)',
                'receiver_message' => '{name} has uploaded your appointment form(s)',
                'default_receiver_message' => '{name} has uploaded your appointment form(s)',
            ],
            [
                'header' => 'Promote Employee',
                'sender_message' => 'You have promoted {name}',
                'default_sender_message' => 'You have promoted {name}',
                'receiver_message' => 'You have been promoted by {name}',
                'default_receiver_message' => 'You have been promoted by {name}',
            ],
        ];

        $jobPortalNotifications = [
            [
                'header' => 'Create Application JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => '{applicant_name} has applied for a position {custom_message}',
                'default_receiver_message' => '{applicant_name} has applied for a position {custom_message}',
            ],
            [
                'header' => 'Approve PDS JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have approved the personal data sheet of applicant {applicant_name}',
                'default_receiver_message' => 'You have approved the personal data sheet of applicant {applicant_name}',
            ],
            [
                'header' => 'Set Schedule JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have set the schedule of applicant {applicant_name} for the {custom_message}',
                'default_receiver_message' => 'You have set the schedule of applicant {applicant_name} for the {custom_message}',
            ],
            [
                'header' => 'Request Reschedule JP',
                'sender_message' => 'You have requested a reschedule for {custom_message}',
                'default_sender_message' => 'You have requested a reschedule for {custom_message}',
                'receiver_message' => 'Applicant {applicant_name} has requested a reschedule for {custom_message}',
                'default_receiver_message' => 'Applicant {applicant_name} has requested a reschedule for {custom_message}',
            ],
            [
                'header' => 'Acknowledge Status JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'Applicant {applicant_name} has acknowledge the status of application for {custom_message}',
                'default_receiver_message' => 'Applicant {applicant_name} has acknowledge the status of application for {custom_message}',
            ],
            [
                'header' => 'Acknowledge Schedule JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'Applicant {applicant_name} has acknowledge the schedule for {custom_message}',
                'default_receiver_message' => 'Applicant {applicant_name} has acknowledge the schedule for {custom_message}',
            ],

            [
                'header' => 'Acknowledge Requirements JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'Applicant {applicant_name} has acknowledge the supplementary requirements',
                'default_receiver_message' => 'Applicant {applicant_name} has acknowledge the supplementary requirements',
            ],

            [
                'header' => 'Approve Reschedule JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have approved the reschedule request of applicant {applicant_name} for the {custom_message}',
                'default_receiver_message' => 'You have approved the reschedule request of applicant {applicant_name} for the {custom_message}',
            ],
            [
                'header' => 'Decline Reschedule JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have decline the reschedule request of applicant {applicant_name} for the {custom_message}',
                'default_receiver_message' => 'You have decline the reschedule request of applicant {applicant_name} for the {custom_message}',
            ],
            [
                'header' => 'Pass Applicant JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have passed applicant {applicant_name} for the {custom_message}',
                'default_receiver_message' => 'You have passed applicant {applicant_name} for the {custom_message}',
            ],
            [
                'header' => 'Fail Applicant JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have failed applicant {applicant_name} for the {custom_message}',
                'default_receiver_message' => 'You have failed applicant {applicant_name} for the {custom_message}',
            ],
            [
                'header' => 'Tag To Another Position JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have tagged the applicant {applicant_name} to another position',
                'default_receiver_message' => 'You have tagged the applicant {applicant_name} to another position',
            ],
            [
                'header' => 'Complete Requirements JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have reviewed the requirements of applicant {applicant_name}',
                'default_receiver_message' => 'You have reviewed the requirements of applicant {applicant_name}',
            ],
            [
                'header' => 'Upload Appointment Form JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have uploaded the appointment form for applicant {applicant_name}',
                'default_receiver_message' => 'You have uploaded the appointment form for applicant {applicant_name}',
            ],
            [
                'header' => 'Hire Applicant JP',
                'sender_message' => '',
                'default_sender_message' => '',
                'receiver_message' => 'You have successfully hired applicant {applicant_name} for the position title {custom_message}',
                'default_receiver_message' => 'You have successfully hired applicant {applicant_name} for the position title {custom_message}',
            ],
            [
                'header' => 'Upload Requirement files JP',
                'sender_message' => 'You have uploaded your {custom_message} requirement file(s)',
                'default_sender_message' => 'You have uploaded your {custom_message} requirement file(s)',
                'receiver_message' => '{applicant_name} applicant has uploaded their {custom_message} requirement file(s)',
                'default_receiver_message' =>'{applicant_name} applicant has uploaded their {custom_message} requirement file(s)',
            ],
        ];


        $notificationmessages = array_merge(
            $notificationmessages,
            $overtimeNotifications,
            $leaveNotifications,
            $loanNotifications,
            $underTimeNotifications,
            $rosterNotifications,
            $employeeCasesNotifications,
            $pdsNotifications,
            $clearanceNotifications,
            $promotionNotifications,
            $jobPortalNotifications,
        );
        NotificationMessages::truncate();
        NotificationMessages::insert($notificationmessages);
    }
}
