<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\LeaveManagement\LeaveSubtype;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;

class ModifyLeaveTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Fetch the leave type, use the name when using the where cluase method by laravel.
        $leaveTypesQuery = LeaveType::select('title')->get()->toArray();
        // Fetch the leave subtypes excluding the leave type.
        $leaveSubTypesQuery = LeaveSubtype::whereNotIn('title', $leaveTypesQuery)->get();
        // After fetching the leave subtype insert it to the leave type model.
        foreach ($leaveSubTypesQuery as $leaveSubType) {
            LeaveType::updateOrCreate(['title', $leaveSubType['title']], [
                'title' =>  $leaveSubType['title'],
            ]);
        }
    }
}
