<?php

namespace Database\Seeders;

use App\Enums\Status;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class MiriamUserAccountsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $collaborators = [
            [
                'name' => 'Angelina Alcazar',
                'email' => $this->generateEmail('Angelina Alcazar'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Gwen Francine Michelle Celine De Jesus',
                'email' => $this->generateEmail('Gwen Francine Michelle Celine De Jesus'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Margarita Dolina',
                'email' => $this->generateEmail('Margarita Dolina'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Arlene Reyes',
                'email' => $this->generateEmail('Arlene Reyes'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Emma Igos',
                'email' => $this->generateEmail('Emma Igos'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Fritzie-May Enriquez',
                'email' => $this->generateEmail('Fritzie May Enriquez'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Jocelyn Romero',
                'email' => $this->generateEmail('Jocelyn Romero'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Ma. Theresa Barcenilla',
                'email' => $this->generateEmail('Ma. Theresa Barcenilla'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Ralph Lauren Anthony',
                'email' => $this->generateEmail('Ralph Lauren Anthony'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Maria Lourdes Chavez',
                'email' => $this->generateEmail('Maria Lourdes Chavez'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Maribel Maranan',
                'email' => $this->generateEmail('Maribel Maranan'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Amabelle Carino',
                'email' => $this->generateEmail('Amabelle Carino'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Maria Caridad Santos',
                'email' => $this->generateEmail('Maria Caridad Santos'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Maria Joanne Garcia',
                'email' => $this->generateEmail('Maria Joanne Garcia'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Marivic Rosario',
                'email' => $this->generateEmail('Marivic Rosario'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Mark Raymond Par',
                'email' => $this->generateEmail('Mark Raymond Par'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Noel Racho',
                'email' => $this->generateEmail('Noel Racho'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Audrey Mae Maxion',
                'email' => $this->generateEmail('Audrey Mae Maxion'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Cristanile Marie Briongos',
                'email' => $this->generateEmail('Cristanile Marie Briongos'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Roselle De Leon',
                'email' => $this->generateEmail('Roselle De Leon'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Chrissel Santos',
                'email' => $this->generateEmail('Chrissel Santos'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'May Jerelyn Mariano',
                'email' => $this->generateEmail('May Jerelyn Mariano'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Cristine Joy David',
                'email' => $this->generateEmail('Cristine Joy David'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Grace Carolynn De Rosas',
                'email' => $this->generateEmail('Grace Carolynn De Rosas'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Jethro Monton',
                'email' => $this->generateEmail('Jethro Monton'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Jose Maribbay',
                'email' => $this->generateEmail('Jose Maribbay'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Vince Andrew Pastor',
                'email' => $this->generateEmail('Vince Andrew Pastor'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Audrey Mae Maxion',
                'email' => $this->generateEmail('Audrey Mae Maxion'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'May Jerelyn Mariano',
                'email' => $this->generateEmail('May Jerelyn Mariano'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Roselle De Leon',
                'email' => $this->generateEmail('Roselle De Leon'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ]
        ];

        foreach ($collaborators as $collaborator) {
            $existingUser = User::where([
                ['email', $collaborator['email']], ['name', $collaborator['name']]
            ])->first();

            if (!$existingUser) {
                $user = User::create($collaborator);
                $user->assignRole('Collaborator dms');
                $user->syncPermissions(1);
            }
        }

        $managers = [
            [
                'name' => 'Dinna Valera',
                'email' => $this->generateEmail('Dinna Valera'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
        ];

        foreach ($managers as $manager) {
            $existingUser = User::where([
                ['email', $manager['email']], ['name', $manager['name']]
            ])->first();

            if (!$existingUser) {
                $user = User::create($manager);
                $user->assignRole('Manager dms');
                $user->syncPermissions(1);
            }
        }

        $contributors = [
            [
                'name' => 'Brenda Condes',
                'email' => $this->generateEmail('Brenda Condes'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Joan Bermal',
                'email' => $this->generateEmail('Joan Bermal'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Mary Joy Arnuco',
                'email' => $this->generateEmail('Mary Joy Arnuco'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Maxima Nabong',
                'email' => $this->generateEmail('Maxima Nabong'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ],
            [
                'name' => 'Sofia Soledad De Guzman',
                'email' => $this->generateEmail('Sofia Soledad De Guzman'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ]
        ];

        foreach ($contributors as $contributor) {
            $existingUser = User::where([
                ['email', $contributor['email']], ['name', $contributor['name']]
            ])->first();

            if (!$existingUser) {
                $user = User::create($contributor);
                $user->assignRole('Contributor dms');
                $user->syncPermissions(1);
            }
        }

        $consumers = [
            [
                'name' => 'Marie Frances Therese De Leon',
                'email' => $this->generateEmail('Marie Frances Therese De Leon'),
                'password' => bcrypt('miriam2024'),
                'email_verified_at' =>  Carbon::now(),
                'status' => Status::ACTIVE
            ]
        ];

        foreach ($consumers as $consumer) {
            $existingUser = User::where([
                ['email', $consumer['email']], ['name', $consumer['name']]
            ])->first();

            if (!$existingUser) {
                $user = User::create($consumer);
                $user->assignRole('Consumer dms');
                $user->syncPermissions(1);
            }
        }
    }

    private function generateEmail($name)
    {
        $parts = explode(' ', $name);
    
        if (count($parts) === 1) {
            $initials = substr($parts[0], 0, 1);
            $lastName = $parts[0];
        } else {
            $initials = '';
            $compoundLastNames = ['de', 'delos', 'dela', 'delas'];
    
            for ($i = 0; $i < count($parts) - 1; $i++) {
                if (in_array(strtolower($parts[$i]), $compoundLastNames)) {
                    continue;
                }
                $initials .= substr($parts[$i], 0, 1);
            }
    
            $lastNameParts = array_slice($parts, -2);

            if (in_array(strtolower($lastNameParts[0]), $compoundLastNames)) {

                $lastName = implode('', $lastNameParts);
            } else {
                $lastName = $parts[count($parts) - 1];
            }
        }
    
        return strtolower("{$initials}.{$lastName}@mc.edu.ph");
    }
    
}
