<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Dms\Models\Files\FileType;

class MimeTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $mimeTypes = [
            'F4V' => ['video/x-f4v'],
            'JPEG' => ['image/jpeg'],
            'JPG' => ['image/jpeg'],
            'PNG' => [
                'image/png',
                'image/vnd.mozilla.apng',
                'image/x-png',
            ],
            'TIFF' => ['image/tiff'],
            'TIF' => ['image/tiff'],
            'WAV' => [
                'audio/vnd.wave',
                'audio/wav',
                'audio/wave',
                'audio/x-pn-wav',
                'audio/x-wav',
            ],
            'MP3' => [
                'audio/mp3',
                'audio/mpeg',
                'audio/mpeg3',
                'audio/x-mpeg-3',
            ],
            'OGG' => [
                'audio/ogg',
                'video/ogg'
            ],
            'AIFF' => [
                'audio/aiff',
                'audio/x-aiff',
            ],
            'WMA' => [
                'audio/x-ms-wma'
            ],
            'FLAC' => [
                'audio/flac',
                'audio/x-flac',
            ],
            'MKV' => [
                'video/x-matroska'
            ],
            'FLV' => [
                'video/x-flv'
            ],
            '3GP' => [
                'audio/3gpp',
                'video/3gpp',
            ],
            'DOC' => [
                'application/msword'
            ],
            'DOCX' => [
                'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
            ],
            'XLS' => [
                'application/vnd.ms-excel'
            ],
            'XLSX' => [
                'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
            ],
            'PDF' => [
                'application/pdf',
                'application/x-pdf',
            ],
            'MP4' => [
                'video/mp4'
            ]
        ];

        foreach ($mimeTypes as $fileExtension => $mimeType) {
            FileType::where('file_ext', $fileExtension)->update([
                'mime_type' => $mimeType
            ]);
        }
    }
}
