<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SPMS\Mfo;

class MfoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $mfos = [
            [
                'name' => 'Core',
                'ordering' => 2
            ],
            [
                'name' => 'Strategic',
                'ordering' => 1
            ],
            [
                'name' => 'Support',
                'ordering' => 3
            ]
        ];

        foreach ($mfos as $mfo) {
            Mfo::updateOrCreate(
            [
                'name' => $mfo['name']
            ],
            [
                'name' => $mfo['name'],
                'ordering' => $mfo['ordering']
            ]);
        }
    }
}
