<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\Payroll\Longevity;

class LongevityPercentageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $records = [
            [
                'percentage' => '5',
                'effectivity_date' =>  '1992-03-26'
            ],
            
        ];

        foreach ($records as $longevity) {
            Longevity::updateOrCreate(
                [
                    'effectivity_date' => $longevity['effectivity_date'],
                ],
                [
                    'percentage' => $longevity['percentage'],
                    'effectivity_date' => $longevity['effectivity_date']
                ]
            );
        }
    }
}
