<?php

namespace Database\Seeders;

use App\Helper\InitialsExtractor;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\LeaveManagement\LeaveSubtype;
use Suiterus\Adg\Models\LeaveManagement\LeaveType;

class LeaveTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $leaveTypes = [
            [
                'title'             => 'Vacation Leave',
                'description'   => 'Sec. 51, Rule XVI, Omnibous Rules Implementing E.O. No. 292',
                'default_increase'  => 1.250,
                'file_attachment'   => true,
                'increase_type'     => 1,   // Monthly
                'status'            => 1,   // Active
                'type'              => 1    // Mandatory
            ],
            [
                'old_title' => 'Forced Leave',
                'title'             => 'Mandatory/Forced Leave',
                'description'   => 'Sec. 25, Rule XVI, Omnibous Rules Implementing E.O. No. 292',
                'default_increase'  => 5.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Sick Leave',
                'description'   => 'Sec 43, Rule XVI, Omnibous Rules Implementing E.O. No. 292',
                'default_increase'  => 1.250,
                'file_attachment'   => true,
                'increase_type'     => 1,   // Monthly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Maternity Leave',
                'description'   => 'R.A. No. 11210 / IRR 66ued by CSC, DOLE and SSS',
                'default_increase'  => 105.00,
                'file_attachment'   => true,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Paternity Leave',
                'description'   => 'R.A. No. 8187 / CSC MC No. 71, s. 1998, as amended',
                'default_increase'  => 7.00,
                'file_attachment'   => true,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Special Privilege Leave',
                'description'   => 'Sec. 21, Rule XVI, Omnibous Rules Implementing E.O. No. 292',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Solo Parent Leave',
                'description'   => 'R.A. No. 8972 / CSC MC No. 8, s. 2004',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Study Leave',
                'description'   => 'Sec. 68, Rule XVI, Omnibous Rules Implementing E.O. No. 292',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => '10-Day VAWC Leave',
                'description'   => 'R.A. No. 9262 / CSC MC No. 25, s. 2010',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Rehabilitation Privilege',
                'description'   => 'Sec. 55, Rule XVI, Omnibous Rules Implementing E.O. No. 292',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Special Leave Benefits for Women',
                'description'   => 'R.A. No. 9710 / CSC MC No. 25, s. 2010',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Special Emergency (Calamity) Leave',
                'description'   => 'CSC MC No. 2, s. 2012, as amended',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Adoption Leave',
                'description'   => 'R.A. No. 8552',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Monetization of Leave Credits',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
            [
                'title'             => 'Terminal Leave',
                'default_increase'  => 3.00,
                'increase_type'     => 2,   // Yearly
                'status'            => 1,   // active
                'type'              => 1    // Mandatory
            ],
        ];
        foreach ($leaveTypes as $leaveType) {
            $leaveType['remark'] = InitialsExtractor::getInitials($leaveType['title']);
            $title = $leaveType['old_title'] ?? $leaveType['title'];
            unset($leaveType['old_title']);
            LeaveType::updateOrCreate(['title' => $title], $leaveType);
        }
    }
}
