<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\SystemModule;
use App\Models\ModulesHierarchy;
use Illuminate\Support\Facades\Artisan;

class HRPermissionModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        //===============Talent Management================
        $successionPermissions = [
            'can show successor',
            'can promote successor',
            'can create successor',
            'can paginate successor',
            'can show critical position',
            'can create critical position',
            'can paginate critical position'
        ];

        $coachingMentoringPermissions = [
            'can update mentorship invite',
            'can create mentorship',
            'can download mentorship attachment',
            'can list mentorship invite',
            'can paginate mentorship invite',
            'can paginate mentorship',
            'can view mentorship session',
            'can create mentorship session',
            'can paginate mentorship session',
            'can update mentorship session',
            'can update mentorship session',
            'can view mentorship report',
            'can create mentorship report',
            'can update mentorship report'
        ];
        //===============Talent Management - END================

        //===============HR Management================

        //===============Employee profile================
        $activeEmployeesPermissions = [
            'can create personal data sheet',
            'can fetch employee paginate',
            'can create employee type history',
        ];

        $pdsUpdateRequestPermissions = [
            'can paginate view update approve decline onhold request personal data sheet'
        ];

        $serviceRecordPermissions = [
            'can paginate employee service record'
        ];

        $employeeCasesPermissions = [
            'can create employee case',
            'can edit employee case',
            'can paginate employee case',
        ];

        //END

        //================Designation & Salaries========================

        $designationPermissions = [
            'can paginate employee with salary',
            'can view employee salary and designation history',
            'can update employee salary and designation',
            'can manage transfers',
            'can assign employee salary and allowances',
            'can create longevity pay history',
            'can paginate longevity pay history',
            'can update longevity pay history'
        ];

        //END

        //==============Loans========================

        $loanPermissions = [
            'can paginate and view employee loans',
            'can create and update employee loan'
        ];

        //END

        //================Leaves========================

        $leaveRecordPermissions = [
            'can paginate and view employee leave records',
            'can update leave balance'
        ];

        $leaveApplicationPermissions = [
            'can paginate and view employee leave application',
            'can approve and decline employee leave application'
        ];


        // ===============HR Management - END================

        // =================Timekeeping================

        $schedulePermissions = [
            'can assign employee schedule',
            'can delete employee schedule',
            'can paginate and view employee schedule',
            'can update employee schedule',
        ];

        $attendancePermissions = [
            'can create employee attendance',
            'can update employee attendance',
            'can delete employee attendance',
            'can paginate and view employee attendance',
            'can download employee attendance template'
        ];

        $rfidPermissions = [
            'can manage rfid'
        ];

        $biometricsPermissions = [
            'can manage biometrics'
        ];

        $rosterPermissions = [
            "can view roster reschedule request",
            "can review reschedule request",
            "can view roster schedule",
            "can view roster table",
            "can set roster status",
            "can update roster",
            "can create roster",
            "can set roster details",
            "can assign roster schedule shift",
            "can paginate roster template",
            "can delete roster template",
            "can list roster template",
            "can create roster template",
            "can create roster from template"
        ];

        $dtrPermissions = [
            'can view employee daily time record'
        ];

        // ================Timekeeping - END================

        // ===============Payroll================

        $generatePayrollPermissions = [
            'can paginate and view payroll',
            'can generate payroll',
            'can approve and void payroll',
            'can download payroll file',
            'can manage leave refund'
        ];

        // ================Payroll - END================

        //================Report================

        $salnReportPermissions = [
            'can paginate and view employee saln report',
            'can approve and decline employee saln report',
        ];

        $absenteeismPermissions = [
            'can paginate absenteeism report', 
            'can download absenteeism report', 
            'can create absenteeism report'
        ];
        //================Report - END================


        //================Recruitment================

        $jobPostPermissions = [
            'can create position job posting',
            'can update position job posting',
            'can paginate position job posting',
            'can download position job posting',
            'can create expenses job posting'
        ];

        $jobRecruitmentPermissions = [
            'can manage job recruitment and list of all applicants'
        ];

        //================Recruitment - END================

        //================Approvals================

        $otAppicationPermissions = [
            'can approve and decline overtime application',
            'can paginate and view overtime application',
            'can delete overtime application',
        ];

        $otReportPermissions = [
            'can approve and decline overtime accomplishment report',
            'can paginate and view overtime accomplishment report'
        ];

        $ctoRecordPermissions = [
            'can paginate and view cto records'
        ];

        $ctoApplicationPermissions = [
            'can paginate and view cto applications',
            'can approve and decline cto applications',
        ];

        $undertimePermissions = [
            'can paginate and view undertime application',
            'can approve and decline undertime application',
            'can delete undertime application'
        ];

        //================Approvals - END================

        //================Exit================

        /**
         * TODO: Add permissions if new exit module is added
         */

        //================Exit - END ================


        //=================Setup================

        $organizationStructurePermission = [
            'can create office',
            'can manage office',
            'can create department',
            'can manage department',
            'can create division',
            'can manage division',
            'can create section',
            'can manage section',
            'can create unit',
            'can manage unit',
            'can create branch',
            'can manage branch',
            'can create corporation',
            'can manage corporation',
        ];

        $schedulesPermissions = [
            'can create schedule type',
            'can manage schedule type',
            'can create schedule title',
            'can manage schedule title',
            'can create timetable',
            'can manage timetable',
            'can manage schedule template',
            'can manage default schedule'
        ];

        $rosterPermissionsSetup = [
            'can create roster legend',
            'can manage roster legend',
            'can create shift',
            'can manage shift',
            'can create roster group',
            'can manage roster group',
            'can create group position',
            'can manage group position'
        ];

        $holidaySuspensionPermissions = [
            'can create holiday type',
            'can manage holiday type',
            'can create holiday',
            'can manage holiday',
            'can create suspension',
            'can manage suspension'
        ];

        $leaveTypePermissons = [
            'can create leave type',
            'can manage leave type',
        ];

        $salaryManagementPermissions = [
            'can create new tranche',
            'can manage new tranche',
            'can manage regular salary grade table',
            'can manage contractual salary grade table',
            'can manage active tranche',
            'can create position',
            'can manage position',
            'can create item code',
            'can manage item code',
        ];

        $parollRemittancePermissions = [
            'can create loan',
            'can manage loan',
            'can create allowance',
            'can manage allowance',
            'can create special pay',
            'can manage special pay',
            'can create contribution',
            'can manage contribution',
            'can create longevity pay',
            'can manage longevity pay',
            'can create night differential pay',
            'can manage night differential pay'
        ];

        $employeeProfilePermissions = [
            'can manage bulk profile',
            'can create employee type',
            'can manage employee type',
            'can create supervisor',
            'can manage supervisor',
            'can create supervisee',
            'can manage supervisee'
        ];

        $biometricsPermissionsSetup = [
            'can manage auto sync setup',
            'can create biometric device setup',
            'can manage biometric device setup'
        ];


        //================Setup - END================



        //================Modules========================

        $talentManagement = [
            'Succession Management' => $successionPermissions,
            'Coaching & Mentoring' => $coachingMentoringPermissions
        ];

        $HrManagement = [
            'Active Employees' => $activeEmployeesPermissions,
            'PDS Update Request' => $pdsUpdateRequestPermissions,
            'Service Record' => $serviceRecordPermissions,
            'Employee Cases' => $employeeCasesPermissions,
            'Designation and Salaries' => $designationPermissions,
            'Loans' => $loanPermissions,
            'Leave Records' => $leaveRecordPermissions,
            'Leave Applications' => $leaveApplicationPermissions
        ];

        $timekeeping = [
            'Schedule' => $schedulePermissions,
            'Attendance' => $attendancePermissions,
            'RFID' => $rfidPermissions,
            'Biometrics' => $biometricsPermissions,
            'Roster' => $rosterPermissions,
            'Daily Time Record' => $dtrPermissions
        ];

        $payroll = [
            'Generate Payroll' => $generatePayrollPermissions
        ];

        $recruitment = [
            'Job Post' => $jobPostPermissions,
            'Job Recruitment and List of All Applicants' => $jobRecruitmentPermissions,
            'Promotion' => []
        ];

        $reports = [
            'Reports' => ['can create reports', 'can paginate reports', 'can download reports'],
            'GSIS Report' => [],
            'Philhealth Report' => [],
            'Pag-IBIG Loan Remittance Report' => [],
            'Pag-IBIG Report' => [],
            'Withholding Tax Report' => [],
            'List Of Employees Credited / Not credited To ATM' => [],
            'Rate Per Day Report' => [],
            'Monthly Report Of Other Income / Deductions' => [],
            '13th And 14th Month Pay Report' => [],
            'Alpha List Report' => [],
            'Tax Refund Report' => [],
            'Representation And Transportation Allowance RATA' => [],
            'Other Special Payroll' => [],
            'SALN Report' => $salnReportPermissions,
            'SALN Excel Report' => [],
            'New Employee Report' => [],
            'Resigned Employee Report' => [],
            'Talent Acquisition Report' => [],
            'New Hire Turnover Rate Report' => ['can paginate new hire turnover rate report', 'can download new hire turnover rate report'],
            'Time to Hire Report' => ['can paginate time to hire report', 'can download time to hire report'],
            'Cost Per Hire' => ['can create cost per hire report','can paginate cost per hire report', 'can download cost per hire report'],
            'Time Since Last Promotion' => ['can create time since last promotion report', 'can paginate time since last promotion report', 'can download time since last promotion report'],
            'Absenteeism Report' => $absenteeismPermissions,
        ];

        $approvals = [
            'Overtime Applications' => $otAppicationPermissions,
            'Overtime Accomplishment Reports' => $otReportPermissions,
            'CTO Records' => $ctoRecordPermissions,
            'CTO Applications' => $ctoApplicationPermissions,
            'Undertime' => $undertimePermissions
        ];

        $spms = [
            'SPMS - Dashboard' => [],
            'Configure' => [],
            'Performance and Commitment Review' => [],
            'Performance Rating Report' => [],
        ];

        $exit = [
            'Exit Interview' => ['can manage exit interview'],
            'Clearance' => ['can manage clearance'],
            'Resigned Employees' => ['can manage resigned employee']
        ];

        $setup = [
            'Organization Structure' => $organizationStructurePermission,
            'Schedules' => $schedulesPermissions,
            'Roster - Setup' => $rosterPermissionsSetup,
            'Holiday and Suspension' => $holidaySuspensionPermissions,
            'Leave' => $leaveTypePermissons,
            'Salary Management' => $salaryManagementPermissions,
            'Payroll and Remittance' => $parollRemittancePermissions,
            'Employee Profile' => $employeeProfilePermissions,
            'Biometrics - Setup' => $biometricsPermissionsSetup
        ];

        //============MODULES - END===============

        $modules = [
            'Dashboard' => ['Dashboard' => []],
            'Talent Management' => $talentManagement,
            'Timekeeping' => $timekeeping,
            'HR Management' => $HrManagement,
            'Payroll' => $payroll,
            'Recruitment' => $recruitment,
            'Reports' => $reports,
            'Approvals' => $approvals,
            'SPMS' => $spms,
            'Exit' => $exit,
            'Audit Trail' => ['Audit Trail' => ['can paginate and view audit trail']],
            'Setup' => $setup
        ];

        foreach ($modules as $key => $value) {

            $parentModule = SystemModule::updateOrCreate(
                ['name' => $key],
                [
                    'name' => $key,
                    'system_id' => 2 // HRIS
                ],
            );

            foreach ($value as $key => $module) {
                $childModule = SystemModule::updateOrCreate([
                    'name' => $key,
                    'system_id' => 2
                ]);

                foreach ($module as $permission) {
                    Permission::updateOrCreate(
                        [

                            'name' => $permission,
                        ],
                        [
                            'name' => $permission,
                            'display_name' => $permission,
                            'system_module_id' => $childModule->id,
                            'guard_name' => 'api',
                        ]
                    );
                }

                ModulesHierarchy::updateOrCreate([
                    'parent_module_id' => $parentModule->id,
                    'child_module_id' => $childModule->id
                ], [
                    'parent_module_id' => $parentModule->id,
                    'child_module_id' => $childModule->id
                ]);
            }
        }

        Artisan::call('cache:clear');
    }
}
