<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Suiterus\Dms\Models\Repositories\Section;
use Suiterus\Dms\Models\Repositories\SectionAccess;
use App\Enums\Status;
use App\Enums\Dms\DriveType;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;


class FolderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        
        $employee201 = [
            [
                "name" => "Employee 201",
                "description" => "Employee list",
                "type" => DriveType::PRIVATE, //private
                "parent_id" => 0,
                "status" => Status::ACTIVE,
                "created_by" => 2,
                "created_at" => now(),
                "updated_at" => now()
            ],
        ];
        
        foreach($employee201 as $folder){
            Section::updateOrCreate(['name' => $folder['name']], $folder);
        }

        $parentId = Section::where("name","Employee 201")->pluck('id')->first();

        $employee201SubFolders = [
            [
                "name" => "Active Employee",
                "description" => "Active Employee list",
                "type" => DriveType::PRIVATE, //private
                "parent_id" => $parentId,
                "status" => Status::ACTIVE,
                "created_by" => 2,
                "created_at" => now(),
                "updated_at" => now()
            ],
            [
                "name" => "Inactive Employee",
                "description" => "Inactive Employee list",
                "type" => DriveType::PRIVATE, //private
                "parent_id" => $parentId,
                "status" => Status::ACTIVE,
                "created_by" => 2,
                "created_at" => now(),
                "updated_at" => now()
            ],
        ];

        foreach($employee201SubFolders as $folder){
            Section::updateOrCreate(['name' => $folder['name']], $folder);
        }

        $inactiveFolderId = Section::where("name","Inactive Employee")->pluck('id')->first();
        $activeFolderId = Section::where("name","Active Employee")->pluck('id')->first();

        $sectionAccess = [
            [
                "section_id" => $parentId,
                'user_id' => 2,
                'access_level' => 1,
                "created_at" => now(),
                "updated_at" => now()
            ],[
                "section_id" => $activeFolderId,
                'user_id' => 2,
                'access_level' => 1,
                "created_at" => now(),
                "updated_at" => now()
            ],
            [
                "section_id" => $inactiveFolderId,
                'user_id' => 2,
                'access_level' => 1,
                "created_at" => now(),
                "updated_at" => now()
            ]
        ];

        foreach($sectionAccess as $access){
            SectionAccess::updateOrCreate(['section_id' => $access['section_id'], 'user_id' => $access['user_id']], $access);
        }


        $folder_employee = [];

        $user = User::role(['Employee'])->get();

        foreach($user as $userFolder){
            $folder_employee[] = [
                'name' =>  EmployeeMetaInfo::where('user_id',$userFolder['id'])->pluck('employee_id')->first().' - '.$userFolder['name'],
                'parent_id' => $userFolder['status'] == Status::ACTIVE ? $activeFolderId : $inactiveFolderId,
                'type' => DriveType::PRIVATE,
                "status" => Status::ACTIVE,
                "created_by" => 2,
                "created_at" => now(),
                "updated_at" => now()
            ];
           
        }

        foreach($folder_employee as $folder){
            Section::updateOrCreate(['name' => $folder['name']], $folder);
        }

        $createdFolders = Section::whereIn('name', array_column($folder_employee, 'name'))->get();

        foreach ($createdFolders as $createdFolder) {
            SectionAccess::updateOrCreate(['section_id' => $createdFolder->id, 'user_id' => 2],
                ['access_level' => 1, 'created_at' => now(), 'updated_at' => now()]
            );
        }
    }
}
