<?php

namespace Database\Seeders;

use App\Enums\FeatureType;
use Illuminate\Database\Seeder;
use Suiterus\Dms\Models\Feature\Feature;

class FeatureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $features = [
            [
                'name' => 'home',
                'title' => 'Home',
                'description' => 'Home',
                'is_enabled' => 1,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'approval',
                'title' => 'Approval',
                'description' => 'Approval',
                'is_enabled' => 1,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'dashboard',
                'title' => 'Dashboard',
                'description' => 'Dashboard',
                'is_enabled' => 1,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'repository',
                'title' => 'Repository',
                'description' => 'Repository',
                'is_enabled' => 1,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'trash_bin',
                'title' => 'Trash Bin',
                'description' => 'Trash Bin',
                'is_enabled' => 1,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'archive',
                'title' => 'Archive',
                'description' => 'Archive',
                'is_enabled' => 1,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'document_log',
                'title' => 'Document Log',
                'description' => 'Document Log',
                'is_enabled' => 0,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'simplified_dashboard',
                'title' => 'Simplified Dashboard',
                'description' => 'Dashboard without uploading and creating of file',
                'is_enabled' => 0,
                'system_id' => 1,
                'type' => FeatureType::ADD_ON
            ],
            [
                'name' => 'file_privacy',
                'title' => 'File Privacy',
                'description' => 'File Privacy',
                'is_enabled' => 1,
                'system_id' => 1,
                'type' => FeatureType::STANDARD
            ],
            [
                'name' => 'sync_account_to_wp',
                'title' => 'Sync Account',
                'description' => 'This will sync account to WORDPRESS system',
                'is_enabled' => 1,
                'system_id' => 2,
                'type' => FeatureType::STANDARD
            ],
        ];

        foreach ($features as $feature) {
            Feature::updateOrCreate(
                ['name' => $feature['name']],
                [
                    'name' => $feature['name'],
                    'title' => $feature['title'],
                    'description' => $feature['description'],
                    'is_enabled' => $feature['is_enabled'],
                    'system_id' => $feature['system_id'],
                    'type' => $feature['type']
                ]
            );
        }
    }
}
