<?php

namespace Database\Seeders;

use App\Enums\Status;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SPMS\EvaluationClassification;

class EvaluationClassificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $evaluationClassifications = [
            [
                'title'         =>  'Patient Care',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Training & Branding',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Research',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Linkages',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Organizational Culture',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Human Capital',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Knowledge Management',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Infrastructure & Equipment',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Finance',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ],
            [
                'title'         =>  'Good Governance',
                'description'   =>  'N/A',
                'status'        =>  Status::ACTIVE
            ]
        ];

        foreach($evaluationClassifications as $evaluationClassification){
            EvaluationClassification::updateOrCreate(['title' => $evaluationClassification['title']], $evaluationClassification);
        }
    }
}
