<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SM\EmployeeType;

class EmployeeTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $employeeTypes = [
            [   
                "title" => "Trainee",
                "abbreviation" => "T",
                "description" => "N/A",
                "status" => 1,
                "created_by" => 1,
                "updated_by" => 1
            ],
            [
                "title" => "Probationary",
                "abbreviation" => "PR",
                "description" => "N/A",
                "status" => 1,
                "created_by" => 1,
                "updated_by" => 1
            ],
            [
                "title" => "Job Order",
                "abbreviation" => "JO",
                "description" => "N/A",
                "status" => 1,
                "created_by" => 1,
                "updated_by" => 1
            ],
            [
                "title" => "Regular",
                "abbreviation" => "R",
                "description" => "N/A",
                "status" => 1,
                "created_by" => 1,
                "updated_by" => 1
            ],
            [
                "title" => "Full time service",
                "abbreviation" => "FT",
                "description" => "N/A",
                "status" => 1,
                "created_by" => 1,
                "updated_by" => 1
            ],
            [
                "title" => "Contractual",
                "abbreviation" => "C",
                "description" => "N/A",
                "status" => 1,
                "created_by" => 1,
                "updated_by" => 1
            ]
               
        ];

        foreach($employeeTypes as $empType){
            EmployeeType::updateOrCreate(['title' => $empType['title'], 'abbreviation' => $empType['abbreviation']],$empType);
        }

        
    }
}
