<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ModulesHierarchy;
use Illuminate\Support\Facades\Artisan;
use App\Models\AccessManagement\GroupManagement\System;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class EmployeePortalPermissionModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $employeePortal = System::UpdateOrCreate(
            ['name' => 'Employee Portal'],
            ['name' => 'Employee Portal']
        );

        $modules = [
            'Dashboard' => [
                'name' => 'Dashboard - Employee',
                'display_name' => 'Dashboard',
                'modules' => [
                    [
                        'name' => 'Dashboard - Employee',
                        'display_name' => 'Dashboard',
                        'permissions' => []
                    ]
                ]
            ],
            'Learning Management' => [
                'name' => 'Learning Management - Employee',
                'display_name' => 'Learning Management',
                'modules' => [
                    [
                        'name' => 'Learning Management - Employee',
                        'display_name' => 'Learning Management',
                        'permissions' => []
                    ]
                ]
            ],
            'SPMS' => [
                'name' => 'SPMS - Employee',
                'display_name' => 'SPMS',
                'modules' => [
                    [
                        'name' => 'SPMS - Employee',
                        'display_name' => 'SPMS',
                        'permissions' => []
                    ]
                ]
            ],
            'Leave' => [
                'name' => 'Leave - Employee',
                'display_name' => 'Leave',
                'modules' => [
                    [
                        'name' => 'Leave - Employee',
                        'display_name' => 'Leave',
                        'permissions' => []
                    ]
                ]
            ],
            'Overtime' => [
                'name' => 'Overtime - Employee',
                'display_name' => 'Overtime',
                'modules' => [
                    [
                        'name' => 'Overtime - Employee',
                        'display_name' => 'Overtime',
                        'permissions' => []
                    ]
                ]
            ],
            'Undertime' => [
                'name' => 'Undertime - Employee',
                'display_name' => 'Undertime',
                'modules' => [
                    [
                        'name' => 'Undertime - Employee',
                        'display_name' => 'Undertime',
                        'permissions' => []
                    ]
                ]
            ],
            'Loan' => [
                'name' => 'Loan - Employee',
                'display_name' => 'Loan',
                'modules' => [
                    [
                        'name' => 'Loan - Employee',
                        'display_name' => 'Loan',
                        'permissions' => []
                    ]
                ]
            ],
            'Payslip' => [
                'name' => 'Payslip - Employee',
                'display_name' => 'Payslip',
                'modules' => [
                    [
                        'name' => 'Payslip - Employee',
                        'display_name' => 'Payslip',
                        'permissions' => []
                    ]
                ]
            ],
            'Talent Management' => [
                'name' => 'Talent Management - Employee',
                'display_name' => 'Talent Management',
                'modules' => [
                    [
                        'name' => 'Talent Management - Employee',
                        'display_name' => 'Talent Management',
                        'permissions' => []
                    ]
                ]
            ],
            'Promotion' => [
                'name' => 'Promotion - Employee',
                'display_name' => 'Promotion',
                'modules' => [
                    [
                        'name' => 'Promotion - Employee',
                        'display_name' => 'Promotion',
                        'permissions' => []
                    ]
                ]
            ],
            'Reports' => [
                'name' => 'Reports - Employee',
                'display_name' => 'Reports',
                'modules' => [
                    [
                        'name' => 'Reports - Employee',
                        'display_name' => 'Reports',
                        'permissions' => []
                    ]
                ]
            ],
            'Form and Certificate' => [
                'name' => 'Form and Certificate - Employee',
                'display_name' => 'Form and Certificate',
                'modules' => [
                    [
                        'name' => 'Form and Certificate - Employee',
                        'display_name' => 'Form and Certificate',
                        'permissions' => []
                    ]
                ]
            ],
            'Exit' => [
                'name' => 'Exit - Employee',
                'display_name' => 'Exit',
                'modules' => [
                    [
                        'name' => 'Exit - Employee',
                        'display_name' => 'Exit',
                        'permissions' => []
                    ]
                ]
            ],
        ];

        foreach ($modules as $module) {

            $parentModule = SystemModule::updateOrCreate(
                [
                    'name' => $module['name'],
                    'display_name' => $module['display_name'],
                    'system_id' => $employeePortal->id
                ],

                [
                    'name' => $module['name'],
                    'display_name' => $module['display_name'],
                    'system_id' => $employeePortal->id
                ],
            );

            foreach ($module['modules'] as $module) {
                $childModule = SystemModule::updateOrCreate([
                    'name' => $module['name'],
                    'display_name' => $module['display_name'],
                    'system_id' => $employeePortal->id
                ]);

                foreach ($module['permissions'] as $permission) {
                    Permission::updateOrCreate(
                        [

                            'name' => $permission,
                        ],
                        [
                            'name' => $permission,
                            'display_name' => $permission,
                            'system_module_id' => $childModule->id,
                            'guard_name' => 'api',
                        ]
                    );
                }

                ModulesHierarchy::updateOrCreate([
                    'parent_module_id' => $parentModule->id,
                    'child_module_id' => $childModule->id
                ], [
                    'parent_module_id' => $parentModule->id,
                    'child_module_id' => $childModule->id
                ]);
            }
        }

        Artisan::call('cache:clear');
    }
}
