<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\EMI\EmployeeExtraField;
use Suiterus\Adg\Services\PDS\PDSEmployeeService;

class EmployeeExtraFieldGroupSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $employeeExtraFields = EmployeeExtraField::get();
        $pdsEmployeeService = new PDSEmployeeService();

        foreach ($employeeExtraFields as $employeeExtraField) {
            $groupName = $pdsEmployeeService->determineGroup($employeeExtraField->table_name, $employeeExtraField->user_id);
            
            $employeeExtraField->eefg_id = $groupName->id;
            $employeeExtraField->save();
        }
    }
}