<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;


class DmsUserRolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $dms_perms = [
            
            //dms
            //group_management
            [
                'name'  => 'can create group',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can edit group',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can soft delete group',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can hard delete group',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can view groups',
                'guard_name'    =>  'api'
            ],

            //section_manager
            [
                'name'  => 'can lock and unlock section',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can remove section lock',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can create section',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can edit section',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can soft delete section',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can view section',
                'guard_name'    =>  'api'
            ],
            [
                'name'  => 'can configure groups',
                'guard_name'    =>  'api'
            ]

        ];
        $developer = Role::findByName('Developer');
        $super_admin = Role::findByName('Super Admin');
        $admin = Role::findByName('Admin');
        $user = Role::findByName('User');
        $employee = Role::findByName('Employee');
        foreach($dms_perms as $perm){
            Permission::create($perm);
            $developer->givePermissionTo($perm['name']);
            $super_admin->givePermissionTo($perm['name']);
            $admin->givePermissionTo($perm['name']);
            $user->givePermissionTo($perm['name']);
            $employee->givePermissionTo($perm['name']);
        }     
        
    }
}
