<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Dms\Models\CustomForm\CustomForm;

class CustomFormSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $form = [
            [
                "type" => "text",
                "label" => "Document Title",
                "formID" => 0,
                "required" => false
            ],
            [
                "type" => "number",
                "label" => "Document Number",
                "formID" => 1,
                "required" => false
            ],
            [
                "type" => "number",
                "label" => "Revision Number",
                "formID" => 2,
                "required" => false
            ],
            [
                "type" => "number",
                "label" => "Retention Period",
                "formID" => 3,
                "required" => false
            ],
            [
                "type" => "number",
                "label" => "Indices",
                "formID" => 4,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "Reason of Request",
                "formID" => 5,
                "required" => false
            ],
            [
                "type" => "date",
                "label" => "Effectivity Date",
                "formID" => 6,
                "required" => false
            ],
            [
                "type" => "date",
                "label" => "Validity Date",
                "formID" => 7,
                "required" => false
            ]
        ];

        $customForm = [
            [
                'document_type_id' => 1,
                'form' => json_encode($form)
            ],
            [
                'document_type_id' => 2,
                'form' => json_encode($form)
            ],
            [
                'document_type_id' => 3,
                'form' => json_encode($form)
            ],
            [
                'document_type_id' => 4,
                'form' => json_encode($form)
            ],
            [
                'document_type_id' => 5,
                'form' => json_encode($form)
            ],
            [
                'document_type_id' => 6,
                'form' => json_encode($form)
            ]
        ];

        CustomForm::insert($customForm);
    }
}
