<?php

namespace Database\Seeders;

use App\Enums\Status;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Controllers\Employee\EmployeeController;
use Suiterus\Adg\Models\SM\Corporation;

class CorporationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $corporations = Corporation::updateOrCreate([
            'name'  =>  'National Kidney and Transplant Institute'
        ],[
            'name'              => 'National Kidney and Transplant Institute',
            'office_code'       => '1000015208',
            'employer_id'       => '202534230001',
            'description'       => 'National Kidney and Transplant Institute',
            'status'            => Status::ACTIVE
        ]);

        //call function to update Corporation Id in Employee Meta Info
        $updateCorpId = new EmployeeController;
        $updateCorpId->updateCorporation();
    }
}
