<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\SM\BulkProfileRules;

class BulkProfileRulesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $bulkProfileRules = [
            [
                "name" => "Employee Type",
                "is_required" => true
            ],
            [
                "name"  =>  "Item Code",
                "is_required" => true
            ],
            [
                "name" => "Position",
                "is_required" => true
            ],
            [
                "name" => "Employee No.",
                "is_required" => true
            ],
            [
                "name" => "First Name",
                "is_required" => true
            ],
            [
                "name" => "Middle Name",
                "is_required" => false
            ],
            [
                "name" => "Last Name",
                "is_required" => true
            ],
            [
                "name" => "Suffix",
                "is_required" => false
            ],
            [
                "name" => "E-mail",
                "is_required" => false
            ],
            [
                "name" => 'Gender',
                "is_required" => false
            ],
            [
                "name" => 'Citizenship',
                "is_required" => false
            ],
            [
                "name" => 'Citizenship Details',
                "is_required" => false
            ],
            [
                "name" => 'Civil Status',
                "is_required" => false
            ],
            [
                "name" => 'Civil Details',
                "is_required" => false
            ],
            [
                "name" => 'Telephone Number',
                "is_required" => false
            ],
            [
                "name" => 'Contact Number',
                "is_required" => false
            ],
            [
                "name" => 'Date of Birth',
                "is_required" => true
            ],
            [
                "name" => 'Place of Birth',
                "is_required" => false
            ],
            [
                "name" => 'House/Block/Lot No.',
                "is_required" => false
            ],
            [
                "name" => 'Street',
                "is_required" => false
            ],
            [
                "name" => 'Subdivision/Village',
                "is_required" => false
            ],
            [
                "name" => 'Barangay',
                "is_required" => false
            ],
            [
                "name" => 'City/Municipality',
                "is_required" => false
            ],
            [
                "name" => 'Province',
                "is_required" => false
            ],
            [
                "name" => 'Zip Code',
                "is_required" => false
            ],
            [
                "name" => "Corporation",
                "is_required" => false
            ],
            [
                "name" => "Branch",
                "is_required" => false
            ],
            [
                "name" => "Division",
                "is_required" => true
            ],
            [
                "name" => "Department",
                "is_required" => true
            ],
        ];

        foreach($bulkProfileRules as $bulkProfileRule){
            BulkProfileRules::updateOrCreate(['name' => $bulkProfileRule['name']], $bulkProfileRule);
        }
    }
}
