<?php

namespace Database\Seeders;

use App\Enums\Biometrics\AutoSync;
use Illuminate\Database\Seeder;
use Suiterus\Adg\Models\Setting;
use App\Enums\HRISModule as HRIS;

class BiometricSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $module = HRIS::BIOMETRIC;

        // Enabled and disabled setting for biometrics auto-sync
        Setting::create([
            'key'           => 'auto-sync-attendance',
            'value'         => AutoSync::DISABLED,
            'name'          => 'Biometrics Auto Sync Attendance',
            'description'   => 'Sets if the system will auto synchronize the attendance records from the biometrics device',
            'module'        => $module
        ]);

        // Time Interval for Biometrics Auto sync if enabled - in SECONDS
        Setting::create([
            'key'           => 'auto-sync-attendance-time',
            'value'         => 1,
            'name'          => 'Biometrics Auto Sync Attendance Time Interval',
            'description'   => 'The intervals in minutes for automatic attendance synchonization if enabled',
            'module'        => $module
        ]);

    }
}
