<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Suiterus\Adg\Controllers\Salary\AllowanceAndPays\EmployeeAllowanceController;
use Suiterus\Adg\Models\Payroll\Allowance;
use Suiterus\Adg\Models\Salary\UserSalary;
use Suiterus\Adg\Models\Salary\EmployeeAllowance;

class AllowanceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $allowances = [ 
            [
                'title'  => 'ECOLA',
                'status' => 1
            ],
            [
                'title'  => 'Load Allowance',
                'status' => 1
            ],
            [
                'title'  => 'Transportation Allowance',
                'status' => 1
            ],
            [
                'title'  => 'Branch Allowance',
                'status' => 1
            ],
            [
                'title'  => 'Gate Allowance',
                'status' => 1
            ],
            [
                'title'  => 'Rice Allowance',
                'status' => 1
            ],
            [
                'title'  => 'Substinence Allowance',
                'status' => 1
            ],
            [
                'title'  => 'Laundry Allowance',
                'status' => 1
            ],
            [
                'title' =>  'Representation and Transportation Allowance(RATA)',
                'status' => 1
            ]
        ];
        foreach($allowances as $allowance){
            Allowance::updateOrCreate(['title' => $allowance['title']], $allowance);
        }        
        
        //call function to sync old Allowance to new table
        $syncAllowance = new EmployeeAllowanceController;
        $syncAllowance->syncAllowances();
      
    }
}
