<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ModulesHierarchy;
use Illuminate\Support\Facades\Artisan;
use App\Models\AccessManagement\GroupManagement\System;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\Role;
use App\Models\AccessManagement\GroupManagement\RoleHasSystemModule;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class AdministrationPermissionModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $employeePortal = System::UpdateOrCreate(
            ['name' => 'Administration'],
            ['name' => 'Administration']
        );

        $modules = [
            'Role Management' => [
                'name' => 'Role Management',
                'display_name' => 'Role Management',
                'modules' => [
                    [
                        'name' => 'Role Management',
                        'display_name' => 'Role Management',
                        'permissions' => []
                    ]
                ]
            ],
            'System Management' => [
                'name' => 'System Management',
                'display_name' => 'System Management',
                'modules' => [
                    [
                        'name' => 'System Management',
                        'display_name' => 'System Management',
                        'permissions' => []
                    ]
                ]
            ],
            'User Management' => [
                'name' => 'User Management',
                'display_name' => 'User Management',
                'modules' => [
                    [
                        'name' => 'User Management',
                        'display_name' => 'User Management',
                        'permissions' => []
                    ]
                ]
            ],
            'Permission Management' => [
                'name' => 'Permission Management',
                'display_name' => 'Permission Management',
                'modules' => [
                    [
                        'name' => 'Permission Management',
                        'display_name' => 'Permission Management',
                        'permissions' => []
                    ]
                ]
            ]
        ];

        foreach ($modules as $module) {

            $parentModule = SystemModule::updateOrCreate(
                [
                    'name' => $module['name'],
                    'display_name' => $module['display_name'],
                    'system_id' => $employeePortal->id
                ],

                [
                    'name' => $module['name'],
                    'display_name' => $module['display_name'],
                    'system_id' => $employeePortal->id
                ],
            );

            foreach ($module['modules'] as $module) {
                $childModule = SystemModule::updateOrCreate([
                    'name' => $module['name'],
                    'display_name' => $module['display_name'],
                    'system_id' => $employeePortal->id
                ]);

                foreach ($module['permissions'] as $permission) {
                    Permission::updateOrCreate(
                        [

                            'name' => $permission,
                        ],
                        [
                            'name' => $permission,
                            'display_name' => $permission,
                            'system_module_id' => $childModule->id,
                            'guard_name' => 'api',
                        ]
                    );
                }

                ModulesHierarchy::updateOrCreate([
                    'parent_module_id' => $parentModule->id,
                    'child_module_id' => $childModule->id
                ], [
                    'parent_module_id' => $parentModule->id,
                    'child_module_id' => $childModule->id
                ]);
            }

            $roles = Role::whereIn('name', ['Developer', 'Admin', 'Super Admin'])->get()->pluck('id');

            foreach ($roles as $id) {
                RoleHasSystemModule::updateOrCreate([
                    'role_id' => $id,
                    'system_module_id' => $parentModule->id
                ]);
            }

        }

        Artisan::call('cache:clear');
    }
}
