<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use App\Models\AccessManagement\GroupManagement\Permission;
use App\Models\AccessManagement\GroupManagement\SystemModule;

class AdditionalSystemModulePermission extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            [
                'name' => 'create personal drive folder',
                'display_name' => 'Create Personal Folder',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'upload document personal drive',
                'display_name' => 'Upload File',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            //Dashboard
            [
                'name' => 'create document personal drive',
                'display_name' => 'Create Document',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'create spreadsheet personal drive',
                'display_name' => 'Create Spreadsheet',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'create spreadsheet private drive',
                'display_name' => 'Create Spreadsheet',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'create spreadsheet shared drive',
                'display_name' => 'Create Spreadsheet',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'create presentation personal drive',
                'display_name' => 'Create Presentation',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'create presentation private drive',
                'display_name' => 'Create Presentation',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'create presentation shared drive',
                'display_name' => 'Create Presentation',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'move file personal drive',
                'display_name' => 'Move File',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'move file private drive',
                'display_name' => 'Move File',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'move file shared drive',
                'display_name' => 'Move File',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'copy file personal drive',
                'display_name' => 'Copy File',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'copy file private drive',
                'display_name' => 'Copy File',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'copy file shared drive',
                'display_name' => 'Copy File',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'delete document personal drive',
                'display_name' => 'Delete',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'update document personal drive',
                'display_name' => 'Update',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'file information personal drive',
                'display_name' => 'File Information',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'file information private drive',
                'display_name' => 'File Information',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'file information shared drive',
                'display_name' => 'File Information',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'configure document personal drive',
                'display_name' => 'Configure Document',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'configure document private drive',
                'display_name' => 'Configure Document',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'configure document shared drive',
                'display_name' => 'Configure Document',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'forward document personal drive',
                'display_name' => 'Forward',
                'guard_name' => 'api',
                'system_module_id' => null
            ],    
            [
                'name' => 'approval document personal drive',
                'display_name' => 'Approval',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'download document personal drive',
                'display_name' => 'Download',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'upload new version personal drive',
                'display_name' => 'Upload New Version',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'upload new version private drive',
                'display_name' => 'Upload New Version',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'upload new version shared drive',
                'display_name' => 'Upload New Version',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'list file version personal drive',
                'display_name' => 'List File Version',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'list file version private drive',
                'display_name' => 'List File Version',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'list file version shared drive',
                'display_name' => 'List File Version',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'upload other attachment personal drive',
                'display_name' => 'Upload Other Attachment',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'upload other attachment private drive',
                'display_name' => 'Upload Other Attachment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'upload other attachment shared drive',
                'display_name' => 'Upload Other Attachment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'list file attachment personal drive',
                'display_name' => 'List File Attachment',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'list file attachment private drive',
                'display_name' => 'List File Attachment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'list file attachment shared drive',
                'display_name' => 'List File Attachment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'assign signatory personal drive',
                'display_name' => 'Assign Signatory',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'assign signatory private drive',
                'display_name' => 'Assign Signatory',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'assign signatory shared drive',
                'display_name' => 'Assign Signatory',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'list signatory personal drive',
                'display_name' => 'List Signatory',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'list signatory private drive',
                'display_name' => 'List Signatory',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'list signatory shared drive',
                'display_name' => 'List Signatory',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'file comment personal drive',
                'display_name' => 'File Comment',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'file comment private drive',
                'display_name' => 'File Comment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'file comment shared drive',
                'display_name' => 'File Comment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'list file comment personal drive',
                'display_name' => 'List File Comment',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'list file comment private drive',
                'display_name' => 'List File Comment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'list file comment shared drive',
                'display_name' => 'List File Comment',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'edit folder name personal drive',
                'display_name' => 'Edit Folder name',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'edit folder name private drive',
                'display_name' => 'Edit Folder name',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'edit folder name shared drive',
                'display_name' => 'Edit Folder name',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'folder information personal drive',
                'display_name' => 'Folder Information',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'folder information private drive',
                'display_name' => 'Folder Information',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'folder information shared drive',
                'display_name' => 'Folder Information',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'folder configure personal drive',
                'display_name' => 'Folder Configure',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'folder configure private drive',
                'display_name' => 'Folder Configure',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'folder configure shared drive',
                'display_name' => 'Folder Configure',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'delete folder personal drive',
                'display_name' => 'Delete Folder',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'delete folder private drive',
                'display_name' => 'Delete Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ],
            [
                'name' => 'delete folder shared drive',
                'display_name' => 'Delete Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],    
            [
                'name' => 'move folder personal drive',
                'display_name' => 'Move Folder',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
            [
                'name' => 'move folder private drive',
                'display_name' => 'Move Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id
            ], 
            [
                'name' => 'move folder shared drive',
                'display_name' => 'Move Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'copy folder personal drive',
                'display_name' => 'Copy Folder',
                'guard_name' => 'api',
                'system_module_id' => null
            ],  
            [
                'name' => 'copy folder private drive',
                'display_name' => 'Copy Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'private folder')->first()->id               
            ],  
            [
                'name' => 'copy folder shared drive',
                'display_name' => 'Copy Folder',
                'guard_name' => 'api',
                'system_module_id' => SystemModule::where('name', 'shared drive')->first()->id
            ],
            [
                'name' => 'can view file status',
                'display_name' => 'File Status',
                'guard_name' => 'api',
                'system_module_id' => null
            ],
        ];

        Permission::insert($permissions);
        Artisan::call('cache:clear');
    }
}
