<?php

namespace Database\Seeders;

use App\Enums\FeatureType;
use Illuminate\Database\Seeder;
use Suiterus\Dms\Models\Feature\Feature;

class AdditionalFeatureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $features = [
            [
                'name' => 'dms',
                'title' => 'DMS',
                'description' => 'Document Management System',
                'is_enabled' => 1, // 1 = enabled, 2 = disabled
                'system_id' => null,
                'type' => FeatureType::SYSTEM
            ],
            [
                'name' => 'hris',
                'title' => 'HRIS',
                'description' => 'Human Resource Management System',
                'is_enabled' => 1, // 1 = enabled, 2 = disabled
                'system_id' => null,
                'type' => FeatureType::SYSTEM
            ],
            [
                'name' => 'crms',
                'title' => 'CRMS',
                'description' => 'Customer Relationship Management System',
                'is_enabled' => 1, // 1 = enabled, 2 = disabled
                'system_id' => null,
                'type' => FeatureType::SYSTEM
            ],
            [
                'name' => 'fms',
                'title' => 'FMS',
                'description' => 'Financial Management System',
                'is_enabled' => 1, // 1 = enabled, 2 = disabled
                'system_id' => null,
                'type' => FeatureType::SYSTEM
            ],
            [
                'name' => 'wms',
                'title' => 'WMS',
                'description' => 'Warehouse Management System',
                'is_enabled' => 1, // 1 = enabled, 2 = disabled
                'system_id' => null,
                'type' => FeatureType::SYSTEM
            ],
        ];
        foreach($features as $feature){
            Feature::updateOrCreate(['name' => $feature['name']], $feature);
        }
    }
}
