<?php

namespace Database\Seeders;

use App\Enums\Status;
use Illuminate\Database\Seeder;
use Suiterus\Dms\Models\Configuration\DocumentType;
use Suiterus\Dms\Models\CustomForm\CustomForm;

class AdditionalCustomFormSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $document_type = DocumentType::updateOrCreate(
            ['name' => 'Contract Forms'],
            ['status' => Status::ACTIVE]
        );
        
        $form = [
            [
                "type" => "text",
                "label" => "Contract no.",
                "formID" => 0,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "Title",
                "formID" => 1,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "Supplier",
                "formID" => 2,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "End user",
                "formID" => 3,
                "required" => false
            ],
            [
                "type" => "date",
                "label" => "Effectivity date",
                "formID" => 4,
                "required" => false
            ],
            [
                "type" => "date",
                "label" => "End of contract",
                "formID" => 5,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "Category",
                "formID" => 6,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "Subcategory",
                "formID" => 7,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "Remarks",
                "formID" => 8,
                "required" => false
            ],
            [
                "type" => "text",
                "label" => "Filename",
                "formID" => 9,
                "required" => false
            ]
        ];

        CustomForm::updateOrCreate(
            ['document_type_id' => $document_type->id], 
            ['form' => json_encode($form)]
        );
    }
}
