<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMetricEvaluationHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('metric_evaluation_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('metric_evaluation_id');
            $table->unsignedBigInteger('user_id');
            $table->json('old')->nullable();
            $table->json('new')->nullable();
            $table->timestamps();

            $table->foreign('metric_evaluation_id')->references('id')->on(env('ADG_DB_DATABASE') . '.metric_evaluation');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('metric_evaluation_histories');
    }
}
