<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrganizationStructureMfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('organization_structure_mfos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('organization_pcr_id');
            $table->unsignedBigInteger('mfo_id');
            $table->double('percentage', 2);
            $table->timestamps();

            $table->foreign('organization_pcr_id')->references('id')->on(env('ADG_DB_DATABASE').'.organization_structure_pcrs')->onDelete('cascade');
            $table->foreign('mfo_id')->references('id')->on(env('ADG_DB_DATABASE').'.mfos');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('organization_structure_mfos');
    }
}
